/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.item.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import mekanism.client.model.ModelFluidTank;
import mekanism.client.render.FluidRenderMap;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.common.item.block.machine.ItemBlockFluidTank;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RenderFluidTankItem
extends ItemStackTileEntityRenderer {
    private static final ModelFluidTank modelFluidTank = new ModelFluidTank();
    private static final FluidRenderMap<Int2ObjectMap<MekanismRenderer.Model3D>> cachedCenterFluids = new FluidRenderMap();
    private static final int stages = 1400;

    public static void resetCachedModels() {
        cachedCenterFluids.clear();
    }

    public void func_239207_a_(@Nonnull ItemStack stack, @Nonnull ItemCameraTransforms.TransformType transformType, @Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight) {
        float fluidScale;
        FluidTankTier tier = ((ItemBlockFluidTank)stack.func_77973_b()).getTier();
        FluidStack fluid = StorageUtils.getStoredFluidFromNBT(stack);
        if (!fluid.isEmpty() && (fluidScale = (float)fluid.getAmount() / (float)tier.getStorage()) > 0.0f) {
            int modelNumber = fluid.getFluid().getAttributes().isGaseous(fluid) ? 1399 : Math.min(1399, (int)(fluidScale * 1399.0f));
            MekanismRenderer.renderObject(this.getFluidModel(fluid, modelNumber), matrix, renderer.getBuffer(Atlases.func_228785_j_()), MekanismRenderer.getColorARGB(fluid, fluidScale), MekanismRenderer.calculateGlowLight(light, fluid), overlayLight, RenderResizableCuboid.FaceDisplay.FRONT, transformType != ItemCameraTransforms.TransformType.GUI);
        }
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, -0.4, 0.5);
        matrix.func_227862_a_(0.9f, 0.8f, 0.9f);
        matrix.func_227862_a_(1.168f, 1.168f, 1.168f);
        matrix.func_227861_a_(0.0, -0.06, 0.0);
        modelFluidTank.render(matrix, renderer, light, overlayLight, tier, stack.func_77962_s());
        matrix.func_227865_b_();
    }

    private MekanismRenderer.Model3D getFluidModel(@Nonnull FluidStack fluid, int stage) {
        if (cachedCenterFluids.containsKey(fluid) && ((Int2ObjectMap)cachedCenterFluids.get(fluid)).containsKey(stage)) {
            return (MekanismRenderer.Model3D)((Int2ObjectMap)cachedCenterFluids.get(fluid)).get(stage);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.setTexture(MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidType.STILL));
        if (fluid.getFluid().getAttributes().getStillTexture(fluid) != null) {
            model.minX = 0.135f;
            model.minY = 0.0725f;
            model.minZ = 0.135f;
            model.maxX = 0.865f;
            model.maxY = 0.0525f + 0.875f * ((float)stage / 1400.0f);
            model.maxZ = 0.865f;
        }
        ((Int2ObjectMap)cachedCenterFluids.computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap())).put(stage, (Object)model);
        return model;
    }
}

