/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.fluid;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.RelativeSide;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.capabilities.holder.fluid.ConfigFluidTankHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.tile.component.TileComponentConfig;
import net.minecraft.util.Direction;

public class FluidTankHelper {
    private final IFluidTankHolder slotHolder;
    private boolean built;

    private FluidTankHelper(IFluidTankHolder slotHolder) {
        this.slotHolder = slotHolder;
    }

    public static FluidTankHelper forSide(Supplier<Direction> facingSupplier) {
        return new FluidTankHelper(new FluidTankHolder(facingSupplier));
    }

    public static FluidTankHelper forSideWithConfig(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
        return new FluidTankHelper(new ConfigFluidTankHolder(facingSupplier, configSupplier));
    }

    public void addTank(@Nonnull IExtendedFluidTank tank) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        if (this.slotHolder instanceof FluidTankHolder) {
            ((FluidTankHolder)this.slotHolder).addTank(tank, new RelativeSide[0]);
        } else if (this.slotHolder instanceof ConfigFluidTankHolder) {
            ((ConfigFluidTankHolder)this.slotHolder).addTank(tank);
        } else {
            throw new IllegalArgumentException("Holder does not know how to add tanks");
        }
    }

    public void addTank(@Nonnull IExtendedFluidTank tank, RelativeSide ... sides) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        if (!(this.slotHolder instanceof FluidTankHolder)) {
            throw new IllegalArgumentException("Holder does not know how to add tanks on specific sides");
        }
        ((FluidTankHolder)this.slotHolder).addTank(tank, sides);
    }

    public IFluidTankHolder build() {
        this.built = true;
        return this.slotHolder;
    }
}

