/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.entangloporter;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.slot.EntangloporterInventorySlot;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;

public class InventoryFrequency
extends Frequency
implements IMekanismInventory,
IMekanismFluidHandler,
IMekanismStrictEnergyHandler,
ITileHeatHandler,
IGasTracker,
IInfusionTracker,
IPigmentTracker,
ISlurryTracker {
    private BasicFluidTank storedFluid;
    private IGasTank storedGas;
    private IInfusionTank storedInfusion;
    private IPigmentTank storedPigment;
    private ISlurryTank storedSlurry;
    private IInventorySlot storedItem;
    public IEnergyContainer storedEnergy;
    private BasicHeatCapacitor storedHeat;
    private List<IInventorySlot> inventorySlots;
    private List<IGasTank> gasTanks;
    private List<IInfusionTank> infusionTanks;
    private List<IPigmentTank> pigmentTanks;
    private List<ISlurryTank> slurryTanks;
    private List<IExtendedFluidTank> fluidTanks;
    private List<IEnergyContainer> energyContainers;
    private List<IHeatCapacitor> heatCapacitors;

    public InventoryFrequency(String n, @Nullable UUID uuid) {
        super(FrequencyType.INVENTORY, n, uuid);
        this.presetVariables();
    }

    public InventoryFrequency() {
        super(FrequencyType.INVENTORY);
    }

    private void presetVariables() {
        this.storedFluid = BasicFluidTank.create(MekanismConfig.general.entangloporterFluidBuffer.get(), this);
        this.fluidTanks = Collections.singletonList(this.storedFluid);
        this.storedGas = ChemicalTankBuilder.GAS.create(MekanismConfig.general.entangloporterChemicalBuffer.get(), this);
        this.gasTanks = Collections.singletonList(this.storedGas);
        this.storedInfusion = ChemicalTankBuilder.INFUSION.create(MekanismConfig.general.entangloporterChemicalBuffer.get(), this);
        this.infusionTanks = Collections.singletonList(this.storedInfusion);
        this.storedPigment = ChemicalTankBuilder.PIGMENT.create(MekanismConfig.general.entangloporterChemicalBuffer.get(), this);
        this.pigmentTanks = Collections.singletonList(this.storedPigment);
        this.storedSlurry = ChemicalTankBuilder.SLURRY.create(MekanismConfig.general.entangloporterChemicalBuffer.get(), this);
        this.slurryTanks = Collections.singletonList(this.storedSlurry);
        this.storedItem = EntangloporterInventorySlot.create(this);
        this.inventorySlots = Collections.singletonList(this.storedItem);
        this.storedEnergy = BasicEnergyContainer.create((FloatingLong)MekanismConfig.general.entangloporterEnergyBuffer.get(), this);
        this.energyContainers = Collections.singletonList(this.storedEnergy);
        this.storedHeat = BasicHeatCapacitor.create(1.0, 1.0, 1000.0, this);
        this.heatCapacitors = Collections.singletonList(this.storedHeat);
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        nbtTags.func_218657_a("energy", (INBT)this.storedEnergy.serializeNBT());
        nbtTags.func_218657_a("fluid", (INBT)this.storedFluid.serializeNBT());
        nbtTags.func_218657_a("gas", (INBT)this.storedGas.serializeNBT());
        nbtTags.func_218657_a("infuseType", (INBT)this.storedInfusion.serializeNBT());
        nbtTags.func_218657_a("pigment", (INBT)this.storedPigment.serializeNBT());
        nbtTags.func_218657_a("slurry", (INBT)this.storedSlurry.serializeNBT());
        nbtTags.func_218657_a("Item", this.storedItem.serializeNBT());
        nbtTags.func_218657_a("heat", (INBT)this.storedHeat.serializeNBT());
    }

    @Override
    protected void read(CompoundNBT nbtTags) {
        super.read(nbtTags);
        this.presetVariables();
        this.storedEnergy.deserializeNBT((INBT)nbtTags.func_74775_l("energy"));
        this.storedFluid.deserializeNBT(nbtTags.func_74775_l("fluid"));
        this.storedGas.deserializeNBT(nbtTags.func_74775_l("gas"));
        this.storedInfusion.deserializeNBT(nbtTags.func_74775_l("infuseType"));
        this.storedPigment.deserializeNBT(nbtTags.func_74775_l("pigment"));
        this.storedSlurry.deserializeNBT(nbtTags.func_74775_l("slurry"));
        this.storedItem.deserializeNBT((INBT)nbtTags.func_74775_l("Item"));
        this.storedHeat.deserializeNBT(nbtTags.func_74775_l("heat"));
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        this.storedEnergy.getEnergy().writeToBuffer(buffer);
        buffer.writeFluidStack(this.storedFluid.getFluid());
        ChemicalUtils.writeChemicalStack(buffer, this.storedGas.getStack());
        ChemicalUtils.writeChemicalStack(buffer, this.storedInfusion.getStack());
        ChemicalUtils.writeChemicalStack(buffer, this.storedPigment.getStack());
        ChemicalUtils.writeChemicalStack(buffer, this.storedSlurry.getStack());
        buffer.func_150786_a((CompoundNBT)this.storedItem.serializeNBT());
        buffer.writeDouble(this.storedHeat.getHeat());
    }

    @Override
    protected void read(PacketBuffer dataStream) {
        super.read(dataStream);
        this.presetVariables();
        this.storedEnergy.setEnergy(FloatingLong.readFromBuffer(dataStream));
        this.storedFluid.setStack(dataStream.readFluidStack());
        this.storedGas.setStack(ChemicalUtils.readGasStack(dataStream));
        this.storedInfusion.setStack(ChemicalUtils.readInfusionStack(dataStream));
        this.storedPigment.setStack(ChemicalUtils.readPigmentStack(dataStream));
        this.storedSlurry.setStack(ChemicalUtils.readSlurryStack(dataStream));
        this.storedItem.deserializeNBT((INBT)dataStream.func_150793_b());
        this.storedHeat.setHeat(dataStream.readDouble());
    }

    @Override
    @Nonnull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.inventorySlots;
    }

    @Override
    @Nonnull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasTanks;
    }

    @Override
    @Nonnull
    public List<IInfusionTank> getInfusionTanks(@Nullable Direction side) {
        return this.infusionTanks;
    }

    @Override
    @Nonnull
    public List<IPigmentTank> getPigmentTanks(@Nullable Direction side) {
        return this.pigmentTanks;
    }

    @Override
    @Nonnull
    public List<ISlurryTank> getSlurryTanks(@Nullable Direction side) {
        return this.slurryTanks;
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    @Override
    @Nonnull
    public List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction side) {
        return this.heatCapacitors;
    }

    @Override
    public void onContentsChanged() {
    }
}

