/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import java.util.List;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.Modules;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public interface IModuleContainerItem {
    default public List<Module> getModules(ItemStack stack) {
        return Modules.loadAll(stack);
    }

    default public <MODULE extends Module> MODULE getModule(ItemStack stack, Modules.ModuleData<MODULE> type) {
        return Modules.load(stack, type);
    }

    default public boolean hasModule(ItemStack stack, Modules.ModuleData<?> type) {
        return ItemDataUtils.getCompound(stack, "modules").func_74764_b(type.getName());
    }

    default public boolean isModuleEnabled(ItemStack stack, Modules.ModuleData<?> type) {
        return this.hasModule(stack, type) && ((Module)this.getModule(stack, type)).isEnabled();
    }

    default public void removeModule(ItemStack stack, Modules.ModuleData<?> type) {
        if (this.hasModule(stack, type)) {
            Object module = this.getModule(stack, type);
            if (((Module)module).getInstalledCount() > 1) {
                ((Module)module).setInstalledCount(((Module)module).getInstalledCount() - 1);
                ((Module)module).save(null);
                ((Module)module).onRemoved(false);
            } else {
                ItemDataUtils.getCompound(stack, "modules").func_82580_o(type.getName());
                ((Module)module).onRemoved(true);
            }
        }
    }

    default public void addModule(ItemStack stack, Modules.ModuleData<?> type) {
        if (this.hasModule(stack, type)) {
            Object module = this.getModule(stack, type);
            ((Module)module).setInstalledCount(((Module)module).getInstalledCount() + 1);
            ((Module)module).save(null);
            ((Module)module).onAdded(false);
        } else {
            if (!ItemDataUtils.hasData(stack, "modules", 10)) {
                ItemDataUtils.setCompound(stack, "modules", new CompoundNBT());
            }
            ItemDataUtils.getCompound(stack, "modules").func_218657_a(type.getName(), (INBT)new CompoundNBT());
            ((Module)Modules.load(stack, type)).onAdded(true);
        }
    }
}

