/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;

public abstract class BufferedTransmitter<ACCEPTOR, NETWORK extends DynamicBufferedNetwork<ACCEPTOR, NETWORK, BUFFER, TRANSMITTER>, BUFFER, TRANSMITTER extends BufferedTransmitter<ACCEPTOR, NETWORK, BUFFER, TRANSMITTER>>
extends Transmitter<ACCEPTOR, NETWORK, TRANSMITTER> {
    public BufferedTransmitter(TileEntityTransmitter tile, TransmissionType ... transmissionTypes) {
        super(tile, transmissionTypes);
    }

    public long getTransmitterNetworkCapacity() {
        return this.hasTransmitterNetwork() ? ((DynamicBufferedNetwork)this.getTransmitterNetwork()).getCapacity() : this.getCapacity();
    }

    protected abstract void pullFromAcceptors();

    public abstract long getCapacity();

    @Nonnull
    public abstract BUFFER getBufferWithFallback();

    public abstract boolean noBufferOrFallback();

    protected boolean canHaveIncompatibleNetworks() {
        return false;
    }

    @Override
    public boolean isValidTransmitter(Transmitter<?, ?, ?> transmitter) {
        BufferedTransmitter other;
        if (this.canHaveIncompatibleNetworks() && transmitter instanceof BufferedTransmitter && (other = (BufferedTransmitter)transmitter).canHaveIncompatibleNetworks() && (this.hasTransmitterNetwork() && other.isOrphan() || other.hasTransmitterNetwork() && this.isOrphan())) {
            return false;
        }
        return super.isValidTransmitter(transmitter);
    }

    @Override
    public void requestsUpdate() {
        if (this.canHaveIncompatibleNetworks()) {
            byte possibleTransmitters = this.getPossibleTransmitterConnections();
            byte possibleAcceptors = this.getPossibleAcceptorConnections();
            byte allPossibleConnections = (byte)(possibleTransmitters | possibleAcceptors);
            byte allCurrentConnections = this.getAllCurrentConnections();
            this.currentTransmitterConnections = possibleTransmitters;
            this.getAcceptorCache().currentAcceptorConnections = possibleAcceptors;
            if (allPossibleConnections != allCurrentConnections) {
                byte changedTransmitters = (byte)(allPossibleConnections ^ allCurrentConnections);
                for (Direction side : EnumUtils.DIRECTIONS) {
                    TileEntityTransmitter tile;
                    if (!BufferedTransmitter.connectionMapContainsSide(changedTransmitters, side) || (tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (IBlockReader)this.getTileWorld(), this.getTilePos().func_177972_a(side))) == null) continue;
                    tile.getTransmitter().refreshConnections(side.func_176734_d());
                }
            }
        }
        super.requestsUpdate();
    }

    @Override
    protected void recheckConnections(byte newlyEnabledTransmitters) {
        if (this.hasTransmitterNetwork()) {
            if (this.canHaveIncompatibleNetworks()) {
                for (Direction side : EnumUtils.DIRECTIONS) {
                    if (!BufferedTransmitter.connectionMapContainsSide(newlyEnabledTransmitters, side)) continue;
                    this.recheckConnectionPrechecked(side);
                }
            }
        } else {
            super.recheckConnections(newlyEnabledTransmitters);
        }
    }

    @Override
    protected void recheckConnection(Direction side) {
        if (this.canHaveIncompatibleNetworks() && this.hasTransmitterNetwork()) {
            this.recheckConnectionPrechecked(side);
        }
    }

    private void recheckConnectionPrechecked(Direction side) {
        TileEntityTransmitter otherTile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (IBlockReader)this.getTileWorld(), this.getTilePos().func_177972_a(side));
        if (otherTile != null) {
            DynamicBufferedNetwork otherNetwork;
            DynamicBufferedNetwork network = (DynamicBufferedNetwork)this.getTransmitterNetwork();
            Transmitter<?, ?, ?> other = otherTile.getTransmitter();
            if (other instanceof BufferedTransmitter && ((BufferedTransmitter)other).canHaveIncompatibleNetworks() && other.hasTransmitterNetwork() && network != (otherNetwork = (DynamicBufferedNetwork)other.getTransmitterNetwork()) && network.isCompatibleWith(otherNetwork)) {
                if (this.noBufferOrFallback()) {
                    DynamicBufferedNetwork tempNetwork = network;
                    network = otherNetwork;
                    otherNetwork = tempNetwork;
                }
                List otherTransmitters = network.adoptTransmittersAndAcceptorsFrom(otherNetwork);
                otherNetwork.deregister();
                network.commit();
                network.clampBuffer();
                other.refreshConnections(side.func_176734_d());
                for (BufferedTransmitter otherTransmitter : otherTransmitters) {
                    otherTransmitter.requestsUpdate();
                }
            }
        }
    }

    @Override
    protected void handleContentsUpdateTag(@Nonnull NETWORK network, @Nonnull CompoundNBT tag) {
        ((DynamicBufferedNetwork)network).updateCapacity();
    }

    @Override
    protected void updateClientNetwork(@Nonnull NETWORK network) {
        super.updateClientNetwork(network);
        ((DynamicBufferedNetwork)network).updateCapacity();
    }

    public abstract BUFFER releaseShare();

    @Nonnull
    public abstract BUFFER getShare();
}

