/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.lib.transmitter.acceptor.AcceptorCache;
import mekanism.common.tier.PipeTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.MechanicalPipeUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MechanicalPipe
extends BufferedTransmitter<IFluidHandler, FluidNetwork, FluidStack, MechanicalPipe>
implements IMekanismFluidHandler,
IUpgradeableTransmitter<MechanicalPipeUpgradeData> {
    public final PipeTier tier;
    @Nonnull
    public FluidStack saveShare = FluidStack.EMPTY;
    private final List<IExtendedFluidTank> tanks;
    public final BasicFluidTank buffer;

    public MechanicalPipe(IBlockProvider blockProvider, TileEntityTransmitter tile) {
        super(tile, TransmissionType.FLUID);
        this.tier = Attribute.getTier(blockProvider.getBlock(), PipeTier.class);
        this.buffer = BasicFluidTank.create(MathUtils.clampToInt(this.getCapacity()), BasicFluidTank.alwaysFalse, BasicFluidTank.alwaysTrue, this);
        this.tanks = Collections.singletonList(this.buffer);
    }

    public AcceptorCache<IFluidHandler> getAcceptorCache() {
        return (AcceptorCache)super.getAcceptorCache();
    }

    @Override
    public PipeTier getTier() {
        return this.tier;
    }

    @Override
    public void pullFromAcceptors() {
        Set<Direction> connections = this.getConnections(ConnectionType.PULL);
        if (!connections.isEmpty()) {
            for (IFluidHandler connectedAcceptor : this.getAcceptorCache().getConnectedAcceptors(connections)) {
                FluidStack bufferWithFallback = this.getBufferWithFallback();
                FluidStack received = bufferWithFallback.isEmpty() ? connectedAcceptor.drain(this.getAvailablePull(), IFluidHandler.FluidAction.SIMULATE) : connectedAcceptor.drain(new FluidStack(bufferWithFallback, this.getAvailablePull()), IFluidHandler.FluidAction.SIMULATE);
                if (received.isEmpty() || !this.takeFluid(received, Action.SIMULATE).isEmpty()) continue;
                FluidStack remainder = this.takeFluid(received, Action.EXECUTE);
                connectedAcceptor.drain(new FluidStack(received, received.getAmount() - remainder.getAmount()), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    private int getAvailablePull() {
        if (this.hasTransmitterNetwork()) {
            return Math.min(this.tier.getPipePullAmount(), ((FluidNetwork)this.getTransmitterNetwork()).fluidTank.getNeeded());
        }
        return Math.min(this.tier.getPipePullAmount(), this.buffer.getNeeded());
    }

    @Override
    @Nullable
    public MechanicalPipeUpgradeData getUpgradeData() {
        return new MechanicalPipeUpgradeData(this.redstoneReactive, this.getConnectionTypesRaw(), this.getShare());
    }

    @Override
    public boolean dataTypeMatches(@Nonnull TransmitterUpgradeData data) {
        return data instanceof MechanicalPipeUpgradeData;
    }

    @Override
    public void parseUpgradeData(@Nonnull MechanicalPipeUpgradeData data) {
        this.redstoneReactive = data.redstoneReactive;
        this.setConnectionTypesRaw(data.connectionTypes);
        this.takeFluid(data.contents, Action.EXECUTE);
    }

    @Override
    public void read(@Nonnull CompoundNBT nbtTags) {
        super.read(nbtTags);
        this.saveShare = nbtTags.func_150297_b("fluid", 10) ? FluidStack.loadFluidStackFromNBT((CompoundNBT)nbtTags.func_74775_l("fluid")) : FluidStack.EMPTY;
        this.buffer.setStack(this.saveShare);
    }

    @Override
    @Nonnull
    public CompoundNBT write(@Nonnull CompoundNBT nbtTags) {
        super.write(nbtTags);
        if (this.hasTransmitterNetwork()) {
            ((FluidNetwork)this.getTransmitterNetwork()).validateSaveShares(this);
        }
        if (this.saveShare.isEmpty()) {
            nbtTags.func_82580_o("fluid");
        } else {
            nbtTags.func_218657_a("fluid", (INBT)this.saveShare.writeToNBT(new CompoundNBT()));
        }
        return nbtTags;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, Direction side) {
        return super.isValidAcceptor(tile, side) && ((AcceptorCache)this.getAcceptorCache()).isAcceptorAndListen(tile, side, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    @Override
    public boolean isValidTransmitter(Transmitter<?, ?, ?> transmitter) {
        if (super.isValidTransmitter(transmitter) && transmitter instanceof MechanicalPipe) {
            MechanicalPipe other;
            FluidStack otherBuffer;
            FluidStack buffer = this.getBufferWithFallback();
            if (buffer.isEmpty() && this.hasTransmitterNetwork() && ((FluidNetwork)this.getTransmitterNetwork()).getPrevTransferAmount() > 0) {
                buffer = ((FluidNetwork)this.getTransmitterNetwork()).lastFluid;
            }
            if ((otherBuffer = (other = (MechanicalPipe)transmitter).getBufferWithFallback()).isEmpty() && other.hasTransmitterNetwork() && ((FluidNetwork)other.getTransmitterNetwork()).getPrevTransferAmount() > 0) {
                otherBuffer = ((FluidNetwork)other.getTransmitterNetwork()).lastFluid;
            }
            return buffer.isEmpty() || otherBuffer.isEmpty() || buffer.isFluidEqual(otherBuffer);
        }
        return false;
    }

    @Override
    public FluidNetwork createEmptyNetwork() {
        return new FluidNetwork();
    }

    @Override
    public FluidNetwork createEmptyNetworkWithID(UUID networkID) {
        return new FluidNetwork(networkID);
    }

    @Override
    public FluidNetwork createNetworkByMerging(Collection<FluidNetwork> networks) {
        return new FluidNetwork(networks);
    }

    @Override
    protected boolean canHaveIncompatibleNetworks() {
        return true;
    }

    @Override
    public long getCapacity() {
        return this.tier.getPipeCapacity();
    }

    @Override
    @Nonnull
    public FluidStack releaseShare() {
        FluidStack ret = this.buffer.getFluid();
        this.buffer.setEmpty();
        return ret;
    }

    @Override
    public boolean noBufferOrFallback() {
        return this.getBufferWithFallback().isEmpty();
    }

    @Override
    @Nonnull
    public FluidStack getBufferWithFallback() {
        FluidStack buffer = this.getShare();
        if (buffer.isEmpty() && this.hasTransmitterNetwork()) {
            return ((FluidNetwork)this.getTransmitterNetwork()).getBuffer();
        }
        return buffer;
    }

    @Override
    @Nonnull
    public FluidStack getShare() {
        return this.buffer.getFluid();
    }

    @Override
    public void takeShare() {
        if (this.hasTransmitterNetwork()) {
            FluidNetwork network = (FluidNetwork)this.getTransmitterNetwork();
            if (!network.fluidTank.isEmpty() && !this.saveShare.isEmpty()) {
                int amount = this.saveShare.getAmount();
                MekanismUtils.logMismatchedStackSize(network.fluidTank.shrinkStack(amount, Action.EXECUTE), amount);
                this.buffer.setStack(this.saveShare);
            }
        }
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        if (this.hasTransmitterNetwork()) {
            return ((FluidNetwork)this.getTransmitterNetwork()).getFluidTanks(side);
        }
        return this.tanks;
    }

    @Override
    public void onContentsChanged() {
        this.getTransmitterTile().markDirty(false);
    }

    @Nonnull
    public FluidStack takeFluid(@Nonnull FluidStack fluid, Action action) {
        if (this.hasTransmitterNetwork()) {
            return ((FluidNetwork)this.getTransmitterNetwork()).fluidTank.insert(fluid, action, AutomationType.INTERNAL);
        }
        return this.buffer.insert(fluid, action, AutomationType.INTERNAL);
    }

    @Override
    protected void handleContentsUpdateTag(@Nonnull FluidNetwork network, @Nonnull CompoundNBT tag) {
        super.handleContentsUpdateTag(network, tag);
        NBTUtils.setFluidStackIfPresent(tag, "fluid", network::setLastFluid);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            network.currentScale = scale;
        });
    }
}

