/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.IQIODriveHolder;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.lib.inventory.HashedItem;
import net.minecraft.item.ItemStack;

public class QIODriveData {
    private final QIODriveKey key;
    private final long countCapacity;
    private final int typeCapacity;
    private final Object2LongMap<HashedItem> itemMap = new Object2LongOpenHashMap();
    private long itemCount;

    public QIODriveData(QIODriveKey key) {
        this.key = key;
        ItemStack stack = key.getDriveStack();
        IQIODriveItem item = (IQIODriveItem)stack.func_77973_b();
        this.countCapacity = item.getCountCapacity(stack);
        this.typeCapacity = item.getTypeCapacity(stack);
        item.loadItemMap(stack, this);
        this.itemCount = this.itemMap.values().stream().mapToLong(Long::longValue).sum();
        key.updateMetadata(this);
    }

    public long add(HashedItem type, long amount) {
        long stored = this.getStored(type);
        if (this.itemCount == this.countCapacity || stored == 0L && this.itemMap.size() == this.typeCapacity) {
            return amount;
        }
        long toAdd = Math.min(amount, this.countCapacity - this.itemCount);
        this.itemMap.put((Object)type, stored + toAdd);
        this.itemCount += toAdd;
        this.key.updateMetadata(this);
        this.key.dataUpdate();
        return amount - toAdd;
    }

    public ItemStack remove(HashedItem type, int amount) {
        ItemStack ret;
        long stored = this.getStored(type);
        if (stored - (long)(ret = type.createStack(Math.min(amount, (int)stored))).func_190916_E() > 0L) {
            this.itemMap.put((Object)type, stored - (long)ret.func_190916_E());
        } else {
            this.itemMap.removeLong((Object)type);
        }
        this.itemCount -= (long)ret.func_190916_E();
        this.key.updateMetadata(this);
        this.key.dataUpdate();
        return ret;
    }

    public long getStored(HashedItem type) {
        return this.itemMap.getOrDefault((Object)type, 0L);
    }

    public Object2LongMap<HashedItem> getItemMap() {
        return this.itemMap;
    }

    public QIODriveKey getKey() {
        return this.key;
    }

    public long getCountCapacity() {
        return this.countCapacity;
    }

    public int getTypeCapacity() {
        return this.typeCapacity;
    }

    public long getTotalCount() {
        return this.itemCount;
    }

    public int getTotalTypes() {
        return this.itemMap.size();
    }

    public static class QIODriveKey {
        private final IQIODriveHolder holder;
        private final int driveSlot;

        public QIODriveKey(IQIODriveHolder holder, int driveSlot) {
            this.holder = holder;
            this.driveSlot = driveSlot;
        }

        public void save(QIODriveData data) {
            this.holder.save(this.driveSlot, data);
        }

        public void dataUpdate() {
            this.holder.onDataUpdate();
        }

        public void updateMetadata(QIODriveData data) {
            ItemStack stack = this.getDriveStack();
            if (!(stack.func_77973_b() instanceof IQIODriveItem)) {
                Mekanism.logger.error("Tried to update QIO meta values on an invalid ItemStack. Something has gone very wrong!");
                return;
            }
            IQIODriveItem.DriveMetadata meta = new IQIODriveItem.DriveMetadata(data.itemCount, data.itemMap.size());
            meta.write(stack);
        }

        public ItemStack getDriveStack() {
            return this.holder.getDriveSlots().get(this.driveSlot).getStack();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.driveSlot;
            result = 31 * result + (this.holder == null ? 0 : this.holder.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof QIODriveKey && ((QIODriveKey)obj).holder == this.holder && ((QIODriveKey)obj).driveSlot == this.driveSlot;
        }
    }
}

