/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.ContainerProvider;
import mekanism.common.inventory.container.item.DictionaryContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemDictionary
extends Item {
    public ItemDictionary(Item.Properties properties) {
        super(properties.func_200917_a(1).func_208103_a(Rarity.UNCOMMON));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        if (MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.descriptionKey)) {
            tooltip.add((ITextComponent)MekanismLang.DESCRIPTION_DICTIONARY.translate(new Object[0]));
        } else {
            tooltip.add((ITextComponent)MekanismLang.HOLD_FOR_DESCRIPTION.translateColored(EnumColor.GRAY, EnumColor.AQUA, MekanismKeyHandler.descriptionKey.func_238171_j_()));
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        World world;
        TileEntity tile;
        PlayerEntity player = context.func_195999_j();
        if (!(player == null || (tile = WorldUtils.getTileEntity((IBlockReader)(world = context.func_195991_k()), pos = context.func_195995_a())) == null && player.func_225608_bj_())) {
            if (!world.field_72995_K) {
                Set tileTags;
                Set blockTags = world.func_180495_p(pos).func_177230_c().getTags();
                Set set = tileTags = tile == null ? Collections.emptySet() : tile.func_200662_C().getTags();
                if (blockTags.isEmpty() && tileTags.isEmpty()) {
                    player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, EnumColor.GRAY, MekanismLang.DICTIONARY_NO_KEY), Util.field_240973_b_);
                } else {
                    this.sendTagsToPlayer(player, MekanismLang.DICTIONARY_BLOCK_TAGS_FOUND, blockTags);
                    this.sendTagsToPlayer(player, MekanismLang.DICTIONARY_TILE_ENTITY_TYPE_TAGS_FOUND, tileTags);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public ActionResultType func_111207_a(@Nonnull ItemStack stack, @Nonnull PlayerEntity player, @Nonnull LivingEntity entity, @Nonnull Hand hand) {
        if (!player.func_225608_bj_()) {
            if (!player.field_70170_p.field_72995_K) {
                this.sendTagsOrEmptyToPlayer(player, MekanismLang.DICTIONARY_ENTITY_TYPE_TAGS_FOUND, entity.func_200600_R().getTags());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        Block block;
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (!world.func_201670_d()) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProvider(stack.func_200301_q(), (i, inv, p) -> new DictionaryContainer(i, inv, hand, stack)), buf -> {
                    buf.func_179249_a((Enum)hand);
                    buf.func_150788_a(stack);
                });
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        BlockRayTraceResult result = MekanismUtils.rayTrace(player, RayTraceContext.FluidMode.ANY);
        if (result.func_216346_c() != RayTraceResult.Type.MISS && (block = world.func_180495_p(result.func_216350_a()).func_177230_c()) instanceof FlowingFluidBlock) {
            if (!world.func_201670_d()) {
                this.sendTagsOrEmptyToPlayer(player, MekanismLang.DICTIONARY_FLUID_TAGS_FOUND, ((FlowingFluidBlock)block).getFluid().getTags());
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    private void sendTagsOrEmptyToPlayer(PlayerEntity player, ILangEntry tagsFoundEntry, Set<ResourceLocation> tags) {
        if (tags.isEmpty()) {
            player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, EnumColor.GRAY, MekanismLang.DICTIONARY_NO_KEY), Util.field_240973_b_);
        } else {
            this.sendTagsToPlayer(player, tagsFoundEntry, tags);
        }
    }

    private void sendTagsToPlayer(PlayerEntity player, ILangEntry tagsFoundEntry, Set<ResourceLocation> tags) {
        if (!tags.isEmpty()) {
            player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, EnumColor.GRAY, tagsFoundEntry), Util.field_240973_b_);
            for (ResourceLocation tag : tags) {
                player.func_145747_a((ITextComponent)MekanismLang.DICTIONARY_KEY.translateColored(EnumColor.DARK_GREEN, tag), Util.field_240973_b_);
            }
        }
    }
}

