/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;

public class HashedItem {
    @Nonnull
    private final ItemStack itemStack;
    private final int hashCode;

    public static HashedItem create(@Nonnull ItemStack stack) {
        return new HashedItem(StackUtils.size(stack, 1));
    }

    public static HashedItem raw(@Nonnull ItemStack stack) {
        return new HashedItem(stack);
    }

    protected HashedItem(@Nonnull ItemStack stack) {
        this.itemStack = stack;
        this.hashCode = this.initHashCode();
    }

    protected HashedItem(HashedItem other) {
        this.itemStack = other.itemStack;
        this.hashCode = other.hashCode;
    }

    @Nonnull
    public ItemStack getStack() {
        return this.itemStack;
    }

    @Nonnull
    public ItemStack createStack(int size) {
        return StackUtils.size(this.itemStack, size);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HashedItem) {
            HashedItem other = (HashedItem)obj;
            return InventoryUtils.areItemsStackable(this.itemStack, other.itemStack);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int initHashCode() {
        int code = 1;
        code = 31 * code + this.itemStack.func_77973_b().hashCode();
        if (this.itemStack.func_77942_o()) {
            code = 31 * code + this.itemStack.func_77978_p().hashCode();
        }
        return code;
    }

    public static class UUIDAwareHashedItem
    extends HashedItem {
        private final UUID uuid;
        private final boolean overrideHash;

        public UUIDAwareHashedItem(ItemStack stack, UUID uuid) {
            super(StackUtils.size(stack, 1));
            this.uuid = uuid;
            this.overrideHash = true;
        }

        public UUIDAwareHashedItem(HashedItem other, UUID uuid) {
            super(other);
            this.uuid = uuid;
            this.overrideHash = false;
        }

        @Nullable
        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (this.overrideHash && this.uuid != null) {
                return obj instanceof UUIDAwareHashedItem && this.uuid.equals(((UUIDAwareHashedItem)obj).uuid) && super.equals(obj);
            }
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            if (this.overrideHash && this.uuid != null) {
                return 31 * super.hashCode() + this.uuid.hashCode();
            }
            return super.hashCode();
        }
    }
}

