/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.container.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBlockPos;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableByte;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableFloat;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableFluidStack;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.container.sync.SyncableShort;
import mekanism.common.inventory.container.sync.chemical.SyncableGasStack;
import mekanism.common.inventory.container.sync.chemical.SyncableInfusionStack;
import mekanism.common.inventory.container.sync.chemical.SyncablePigmentStack;
import mekanism.common.inventory.container.sync.chemical.SyncableSlurryStack;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.network.container.property.BlockPosPropertyData;
import mekanism.common.network.container.property.BooleanPropertyData;
import mekanism.common.network.container.property.BytePropertyData;
import mekanism.common.network.container.property.DoublePropertyData;
import mekanism.common.network.container.property.FloatPropertyData;
import mekanism.common.network.container.property.FloatingLongPropertyData;
import mekanism.common.network.container.property.FluidStackPropertyData;
import mekanism.common.network.container.property.FrequencyPropertyData;
import mekanism.common.network.container.property.IntPropertyData;
import mekanism.common.network.container.property.ItemStackPropertyData;
import mekanism.common.network.container.property.LongPropertyData;
import mekanism.common.network.container.property.PropertyData;
import mekanism.common.network.container.property.ShortPropertyData;
import mekanism.common.network.container.property.chemical.GasStackPropertyData;
import mekanism.common.network.container.property.chemical.InfusionStackPropertyData;
import mekanism.common.network.container.property.chemical.PigmentStackPropertyData;
import mekanism.common.network.container.property.chemical.SlurryStackPropertyData;
import mekanism.common.network.container.property.list.ListPropertyData;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public enum PropertyType {
    BOOLEAN(Boolean.TYPE, false, (getter, setter) -> SyncableBoolean.create(() -> PropertyType.lambda$null$0((Supplier)getter), setter::accept), (property, buffer) -> new BooleanPropertyData((short)property, buffer.readBoolean())),
    BYTE(Byte.TYPE, (byte)0, (getter, setter) -> SyncableByte.create(() -> PropertyType.lambda$null$3((Supplier)getter), setter::accept), (property, buffer) -> new BytePropertyData((short)property, buffer.readByte())),
    DOUBLE(Double.TYPE, 0.0, (getter, setter) -> SyncableDouble.create(() -> PropertyType.lambda$null$6((Supplier)getter), setter::accept), (property, buffer) -> new DoublePropertyData((short)property, buffer.readDouble())),
    FLOAT(Float.TYPE, Float.valueOf(0.0f), (getter, setter) -> SyncableFloat.create(() -> PropertyType.lambda$null$9((Supplier)getter), setter::accept), (property, buffer) -> new FloatPropertyData((short)property, buffer.readFloat())),
    INT(Integer.TYPE, 0, (getter, setter) -> SyncableInt.create(() -> PropertyType.lambda$null$12((Supplier)getter), setter::accept), (property, buffer) -> new IntPropertyData((short)property, buffer.func_150792_a())),
    LONG(Long.TYPE, 0L, (getter, setter) -> SyncableLong.create(() -> PropertyType.lambda$null$15((Supplier)getter), setter::accept), (property, buffer) -> new LongPropertyData((short)property, buffer.func_179260_f())),
    SHORT(Short.TYPE, (short)0, (getter, setter) -> SyncableShort.create(() -> PropertyType.lambda$null$18((Supplier)getter), setter::accept), (property, buffer) -> new ShortPropertyData((short)property, buffer.readShort())),
    ITEM_STACK(ItemStack.class, ItemStack.field_190927_a, (getter, setter) -> SyncableItemStack.create(() -> PropertyType.lambda$null$21((Supplier)getter), setter::accept), (property, buffer) -> new ItemStackPropertyData((short)property, buffer.func_150791_c())),
    FLUID_STACK(FluidStack.class, FluidStack.EMPTY, (getter, setter) -> SyncableFluidStack.create(() -> PropertyType.lambda$null$24((Supplier)getter), setter::accept), (property, buffer) -> new FluidStackPropertyData((short)property, buffer.readFluidStack())),
    GAS_STACK(GasStack.class, GasStack.EMPTY, (getter, setter) -> SyncableGasStack.create(() -> PropertyType.lambda$null$27((Supplier)getter), setter::accept), (property, buffer) -> new GasStackPropertyData((short)property, ChemicalUtils.readGasStack(buffer))),
    INFUSION_STACK(InfusionStack.class, InfusionStack.EMPTY, (getter, setter) -> SyncableInfusionStack.create(() -> PropertyType.lambda$null$30((Supplier)getter), setter::accept), (property, buffer) -> new InfusionStackPropertyData((short)property, ChemicalUtils.readInfusionStack(buffer))),
    PIGMENT_STACK(PigmentStack.class, PigmentStack.EMPTY, (getter, setter) -> SyncablePigmentStack.create(() -> PropertyType.lambda$null$33((Supplier)getter), setter::accept), (property, buffer) -> new PigmentStackPropertyData((short)property, ChemicalUtils.readPigmentStack(buffer))),
    SLURRY_STACK(SlurryStack.class, SlurryStack.EMPTY, (getter, setter) -> SyncableSlurryStack.create(() -> PropertyType.lambda$null$36((Supplier)getter), setter::accept), (property, buffer) -> new SlurryStackPropertyData((short)property, ChemicalUtils.readSlurryStack(buffer))),
    FREQUENCY(Frequency.class, null, (getter, setter) -> SyncableFrequency.create(() -> PropertyType.lambda$null$39((Supplier)getter), setter::accept), FrequencyPropertyData::readFrequency),
    LIST(ArrayList.class, Collections.emptyList(), (getter, setter) -> null, ListPropertyData::readList),
    BLOCK_POS(BlockPos.class, null, (getter, setter) -> SyncableBlockPos.create(() -> PropertyType.lambda$null$42((Supplier)getter), setter::accept), (property, buffer) -> new BlockPosPropertyData((short)property, buffer.readBoolean() ? buffer.func_179259_c() : null)),
    FLOATING_LONG(FloatingLong.class, FloatingLong.ZERO, (getter, setter) -> SyncableFloatingLong.create(() -> PropertyType.lambda$null$45((Supplier)getter), setter::accept), (property, buffer) -> new FloatingLongPropertyData((short)property, FloatingLong.readFromBuffer(buffer)));

    private final Class<?> type;
    private final Object defaultValue;
    private final BiFunction<Supplier<Object>, Consumer<Object>, ISyncableData> creatorFunction;
    private final BiFunction<Short, PacketBuffer, PropertyData> dataCreatorFunction;
    private static final PropertyType[] VALUES;

    private PropertyType(Class<?> type, Object defaultValue, BiFunction<Supplier<Object>, Consumer<Object>, ISyncableData> creatorFunction, BiFunction<Short, PacketBuffer, PropertyData> dataCreatorFunction) {
        this.type = type;
        this.defaultValue = defaultValue;
        this.creatorFunction = creatorFunction;
        this.dataCreatorFunction = dataCreatorFunction;
    }

    public <T> T getDefault() {
        return (T)this.defaultValue;
    }

    public static PropertyType getFromType(Class<?> type) {
        for (PropertyType propertyType : VALUES) {
            if (type != propertyType.type) continue;
            return propertyType;
        }
        return null;
    }

    public PropertyData createData(short property, PacketBuffer buffer) {
        return this.dataCreatorFunction.apply(property, buffer);
    }

    public ISyncableData create(Supplier<Object> supplier, Consumer<Object> consumer) {
        return this.creatorFunction.apply(supplier, consumer);
    }

    private static /* synthetic */ FloatingLong lambda$null$45(Supplier getter) {
        return (FloatingLong)getter.get();
    }

    private static /* synthetic */ BlockPos lambda$null$42(Supplier getter) {
        return (BlockPos)getter.get();
    }

    private static /* synthetic */ Frequency lambda$null$39(Supplier getter) {
        return (Frequency)getter.get();
    }

    private static /* synthetic */ SlurryStack lambda$null$36(Supplier getter) {
        return (SlurryStack)getter.get();
    }

    private static /* synthetic */ PigmentStack lambda$null$33(Supplier getter) {
        return (PigmentStack)getter.get();
    }

    private static /* synthetic */ InfusionStack lambda$null$30(Supplier getter) {
        return (InfusionStack)getter.get();
    }

    private static /* synthetic */ GasStack lambda$null$27(Supplier getter) {
        return (GasStack)getter.get();
    }

    private static /* synthetic */ FluidStack lambda$null$24(Supplier getter) {
        return (FluidStack)getter.get();
    }

    private static /* synthetic */ ItemStack lambda$null$21(Supplier getter) {
        return (ItemStack)getter.get();
    }

    private static /* synthetic */ short lambda$null$18(Supplier getter) {
        return (Short)getter.get();
    }

    private static /* synthetic */ long lambda$null$15(Supplier getter) {
        return (Long)getter.get();
    }

    private static /* synthetic */ int lambda$null$12(Supplier getter) {
        return (Integer)getter.get();
    }

    private static /* synthetic */ float lambda$null$9(Supplier getter) {
        return ((Float)getter.get()).floatValue();
    }

    private static /* synthetic */ double lambda$null$6(Supplier getter) {
        return (Double)getter.get();
    }

    private static /* synthetic */ byte lambda$null$3(Supplier getter) {
        return (Byte)getter.get();
    }

    private static /* synthetic */ boolean lambda$null$0(Supplier getter) {
        return (Boolean)getter.get();
    }

    static {
        VALUES = PropertyType.values();
    }
}

