/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ItemStackToEnergyRecipeSerializer<RECIPE extends ItemStackToEnergyRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public ItemStackToEnergyRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray input = JSONUtils.func_151202_d((JsonObject)json, (String)"input") ? JSONUtils.func_151214_t((JsonObject)json, (String)"input") : JSONUtils.func_152754_s((JsonObject)json, (String)"input");
        ItemStackIngredient inputIngredient = ItemStackIngredient.deserialize((JsonElement)input);
        FloatingLong output = SerializerHelper.getFloatingLong(json, "output");
        if (output.isZero()) {
            throw new JsonSyntaxException("Expected output to be greater than zero.");
        }
        return this.factory.create(recipeId, inputIngredient, output);
    }

    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            ItemStackIngredient inputIngredient = ItemStackIngredient.read(buffer);
            FloatingLong output = FloatingLong.readFromBuffer(buffer);
            return this.factory.create(recipeId, inputIngredient, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading itemstack to energy recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        try {
            ((ItemStackToEnergyRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing itemstack to energy recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends ItemStackToEnergyRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, FloatingLong var3);
    }
}

