/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class NucleosynthesizingRecipeSerializer<RECIPE extends NucleosynthesizingRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public NucleosynthesizingRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray itemInput = JSONUtils.func_151202_d((JsonObject)json, (String)"itemInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"itemInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"itemInput");
        ItemStackIngredient itemIngredient = ItemStackIngredient.deserialize((JsonElement)itemInput);
        JsonArray gasInput = JSONUtils.func_151202_d((JsonObject)json, (String)"gasInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"gasInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"gasInput");
        GasStackIngredient gasIngredient = GasStackIngredient.deserialize((JsonElement)gasInput);
        JsonElement ticks = json.get("duration");
        if (!JSONUtils.func_188175_b((JsonElement)ticks)) {
            throw new JsonSyntaxException("Expected duration to be a number greater than zero.");
        }
        int duration = ticks.getAsJsonPrimitive().getAsInt();
        if (duration <= 0) {
            throw new JsonSyntaxException("Expected duration to be a number greater than zero.");
        }
        ItemStack itemOutput = SerializerHelper.getItemStack(json, "output");
        if (itemOutput.func_190926_b()) {
            throw new JsonSyntaxException("Nucleosynthesizing item output must not be empty.");
        }
        return this.factory.create(recipeId, itemIngredient, gasIngredient, itemOutput, duration);
    }

    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            ItemStackIngredient inputSolid = ItemStackIngredient.read(buffer);
            GasStackIngredient inputGas = GasStackIngredient.read(buffer);
            ItemStack outputItem = buffer.func_150791_c();
            int duration = buffer.func_150792_a();
            return this.factory.create(recipeId, inputSolid, inputGas, outputItem, duration);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading nucleosynthesizing recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        try {
            ((NucleosynthesizingRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing nucleosynthesizing recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends NucleosynthesizingRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, GasStackIngredient var3, ItemStack var4, int var5);
    }
}

