/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.factory;

import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackGasToItemStackCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.tile.factory.TileEntityItemToItemFactory;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.upgrade.AdvancedMachineUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.item.ItemStack;

public class TileEntityItemStackGasToItemStackFactory
extends TileEntityItemToItemFactory<ItemStackGasToItemStackRecipe>
implements IHasDumpButton {
    private final ILongInputHandler<@NonNull GasStack> gasInputHandler = InputHelper.getInputHandler(this.gasTank);
    private double secondaryEnergyPerTickMultiplier = 1.0;
    private GasInventorySlot extraSlot;
    private IGasTank gasTank;

    public TileEntityItemStackGasToItemStackFactory(IBlockProvider blockProvider) {
        super(blockProvider);
        this.configComponent.addSupported(TransmissionType.GAS);
        this.configComponent.setupInputConfig(TransmissionType.GAS, this.gasTank);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        this.gasTank = ChemicalTankBuilder.GAS.input(210L * (long)this.tier.processes, gas -> this.containsRecipe(recipe -> ((GasStackIngredient)recipe.getChemicalInput()).testType(gas)), this::onContentsChangedUpdateSorting);
        builder.addTank(this.gasTank);
        return builder.build();
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener updateSortingListener) {
        super.addSlots(builder, updateSortingListener);
        this.extraSlot = GasInventorySlot.fillOrConvert(this.gasTank, () -> ((TileEntityItemStackGasToItemStackFactory)this).func_145831_w(), this, 7, 57);
        builder.addSlot(this.extraSlot);
    }

    public IGasTank getGasTank() {
        return this.gasTank;
    }

    @Override
    @Nullable
    protected GasInventorySlot getExtraSlot() {
        return this.extraSlot;
    }

    @Override
    public boolean isValidInputItem(@Nonnull ItemStack stack) {
        return this.containsRecipe(recipe -> recipe.getItemInput().testType(stack));
    }

    @Override
    protected int getNeededInput(ItemStackGasToItemStackRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt(recipe.getItemInput().getNeededAmount(inputStack));
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<ItemStackGasToItemStackRecipe> cached, @Nonnull ItemStack stack) {
        if (cached != null) {
            ItemStackGasToItemStackRecipe cachedRecipe = cached.getRecipe();
            return cachedRecipe.getItemInput().testType(stack) && (this.gasTank.isEmpty() || ((GasStackIngredient)cachedRecipe.getChemicalInput()).testType(this.gasTank.getType()));
        }
        return false;
    }

    @Override
    protected ItemStackGasToItemStackRecipe findRecipe(int process, @Nonnull ItemStack fallbackInput, @Nonnull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        GasStack gasStack = (GasStack)this.gasTank.getStack();
        Gas gas = (Gas)gasStack.getType();
        ItemStack output = outputSlot.getStack();
        return (ItemStackGasToItemStackRecipe)this.findFirstRecipe(recipe -> {
            if (recipe.getItemInput().testType(fallbackInput) && (gasStack.isEmpty() || ((GasStackIngredient)recipe.getChemicalInput()).testType(gas))) {
                return InventoryUtils.areItemsStackable(recipe.getOutput(fallbackInput, gasStack), output);
            }
            return false;
        });
    }

    @Override
    protected void handleSecondaryFuel() {
        this.extraSlot.fillTankOrConvert();
    }

    @Override
    @Nonnull
    public MekanismRecipeType<ItemStackGasToItemStackRecipe> getRecipeType() {
        switch (this.field_200663_e) {
            case INJECTING: {
                return MekanismRecipeType.INJECTING;
            }
            case PURIFYING: {
                return MekanismRecipeType.PURIFYING;
            }
        }
        return MekanismRecipeType.COMPRESSING;
    }

    @Override
    @Nullable
    public ItemStackGasToItemStackRecipe getRecipe(int cacheIndex) {
        ItemStack stack = (ItemStack)this.inputHandlers[cacheIndex].getInput();
        if (stack.func_190926_b()) {
            return null;
        }
        GasStack gasStack = (GasStack)this.gasInputHandler.getInput();
        if (gasStack.isEmpty()) {
            return null;
        }
        return (ItemStackGasToItemStackRecipe)this.findFirstRecipe(recipe -> recipe.test(stack, gasStack));
    }

    @Override
    public CachedRecipe<ItemStackGasToItemStackRecipe> createNewCachedRecipe(@Nonnull ItemStackGasToItemStackRecipe recipe, int cacheIndex) {
        LongSupplier secondaryEnergyUsage = this.getSupportedUpgrade().contains(Upgrade.GAS) ? () -> StatUtils.inversePoisson(this.secondaryEnergyPerTickMultiplier) : () -> MathUtils.clampToLong(Math.ceil(this.secondaryEnergyPerTickMultiplier));
        return new ItemStackGasToItemStackCachedRecipe<ItemStackGasToItemStackRecipe>(recipe, (IInputHandler<ItemStack>)this.inputHandlers[cacheIndex], this.gasInputHandler, secondaryEnergyUsage, (IOutputHandler<ItemStack>)this.outputHandlers[cacheIndex]).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(() -> this.ticksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    public boolean hasSecondaryResourceBar() {
        return true;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED || upgrade == Upgrade.GAS && this.getSupportedUpgrade().contains(Upgrade.GAS)) {
            this.secondaryEnergyPerTickMultiplier = MekanismUtils.getGasPerTickMeanMultiplier(this);
        }
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof AdvancedMachineUpgradeData) {
            super.parseUpgradeData(upgradeData);
            AdvancedMachineUpgradeData data = (AdvancedMachineUpgradeData)upgradeData;
            this.gasTank.deserializeNBT(data.stored.serializeNBT());
            this.extraSlot.deserializeNBT(data.gasSlot.serializeNBT());
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @Override
    @Nonnull
    public AdvancedMachineUpgradeData getUpgradeData() {
        return new AdvancedMachineUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, this.gasTank, this.extraSlot, this.energySlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }

    @Override
    public void dump() {
        this.gasTank.setEmpty();
    }
}

