/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.interfaces;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.ICachedRecipeHolder;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public interface ITileCachedRecipeHolder<RECIPE extends MekanismRecipe>
extends ICachedRecipeHolder<RECIPE> {
    @Nullable
    default public World getTileWorld() {
        if (this instanceof TileEntity) {
            return ((TileEntity)this).func_145831_w();
        }
        return null;
    }

    @Nonnull
    public MekanismRecipeType<RECIPE> getRecipeType();

    default public boolean containsRecipe(@Nonnull Predicate<RECIPE> matchCriteria) {
        return this.getRecipeType().contains(this.getTileWorld(), matchCriteria);
    }

    @Nullable
    default public RECIPE findFirstRecipe(@Nonnull Predicate<RECIPE> matchCriteria) {
        return this.getRecipeType().findFirst(this.getTileWorld(), matchCriteria);
    }

    @Override
    default public boolean invalidateCache() {
        return CommonWorldTickHandler.flushTagAndRecipeCaches;
    }
}

