/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.FluidSlurryToSlurryCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.inputs.chemical.SlurryStackIngredient;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.SlurryInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.MekanismUtils;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityChemicalWasher
extends TileEntityRecipeMachine<FluidSlurryToSlurryRecipe> {
    public static final long MAX_SLURRY = 10000L;
    public static final int MAX_FLUID = 10000;
    public BasicFluidTank fluidTank;
    public ISlurryTank inputTank;
    public ISlurryTank outputTank;
    public FloatingLong clientEnergyUsed = FloatingLong.ZERO;
    private final IOutputHandler<@NonNull SlurryStack> outputHandler;
    private final IInputHandler<@NonNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NonNull SlurryStack> slurryInputHandler;
    private MachineEnergyContainer<TileEntityChemicalWasher> energyContainer;
    private FluidInventorySlot fluidSlot;
    private OutputInventorySlot fluidOutputSlot;
    private SlurryInventorySlot slurryOutputSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityChemicalWasher() {
        super(MekanismBlocks.CHEMICAL_WASHER);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.SLURRY, TransmissionType.FLUID, TransmissionType.ENERGY);
        this.configComponent.setupItemIOConfig(Collections.singletonList(this.fluidSlot), Arrays.asList(this.slurryOutputSlot, this.fluidOutputSlot), this.energySlot, true);
        this.configComponent.setupIOConfig(TransmissionType.SLURRY, this.inputTank, this.outputTank, RelativeSide.RIGHT).setEjecting(true);
        this.configComponent.setupInputConfig(TransmissionType.FLUID, this.fluidTank);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM, TransmissionType.SLURRY);
        this.fluidInputHandler = InputHelper.getInputHandler(this.fluidTank);
        this.slurryInputHandler = InputHelper.getInputHandler(this.inputTank);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputTank);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Slurry, SlurryStack, ISlurryTank> getInitialSlurryTanks() {
        ChemicalTankHelper<Slurry, SlurryStack, ISlurryTank> builder = ChemicalTankHelper.forSideSlurryWithConfig(this::getDirection, this::getConfig);
        this.inputTank = ChemicalTankBuilder.SLURRY.input(10000L, slurry -> this.containsRecipe(recipe -> ((SlurryStackIngredient)recipe.getChemicalInput()).testType(slurry)), this);
        builder.addTank(this.inputTank);
        this.outputTank = ChemicalTankBuilder.SLURRY.output(10000L, this);
        builder.addTank(this.outputTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.fluidTank = BasicFluidTank.input(10000, fluid -> this.containsRecipe(recipe -> recipe.getFluidInput().testType(fluid)), this);
        builder.addTank(this.fluidTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.fluidSlot = FluidInventorySlot.fill(this.fluidTank, this, 180, 71);
        builder.addSlot(this.fluidSlot);
        this.fluidOutputSlot = OutputInventorySlot.at(this, 180, 102);
        builder.addSlot(this.fluidOutputSlot);
        this.slurryOutputSlot = SlurryInventorySlot.drain(this.outputTank, this, 152, 56);
        builder.addSlot(this.slurryOutputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityChemicalWasher)this).func_145831_w(), this, 152, 5);
        builder.addSlot(this.energySlot);
        this.slurryOutputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.fluidSlot.setSlotType(ContainerSlotType.INPUT);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.fluidSlot.fillTank(this.fluidOutputSlot);
        this.slurryOutputSlot.drainTank();
        FloatingLong prev = this.energyContainer.getEnergy().copyAsConst();
        this.cachedRecipe = this.getUpdatedCache(0);
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
        }
        this.clientEnergyUsed = prev.subtract(this.energyContainer.getEnergy());
    }

    @Override
    @Nonnull
    public MekanismRecipeType<FluidSlurryToSlurryRecipe> getRecipeType() {
        return MekanismRecipeType.WASHING;
    }

    @Override
    @Nullable
    public FluidSlurryToSlurryRecipe getRecipe(int cacheIndex) {
        SlurryStack slurryStack = this.slurryInputHandler.getInput();
        if (slurryStack.isEmpty()) {
            return null;
        }
        FluidStack fluid = this.fluidInputHandler.getInput();
        if (fluid.isEmpty()) {
            return null;
        }
        return (FluidSlurryToSlurryRecipe)this.findFirstRecipe(recipe -> recipe.test(fluid, slurryStack));
    }

    @Override
    @Nullable
    public CachedRecipe<FluidSlurryToSlurryRecipe> createNewCachedRecipe(@Nonnull FluidSlurryToSlurryRecipe recipe, int cacheIndex) {
        return new FluidSlurryToSlurryCachedRecipe(recipe, this.fluidInputHandler, this.slurryInputHandler, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setOnFinish(() -> this.markDirty(false)).setPostProcessOperations(currentMax -> {
            if (currentMax <= 0) {
                return currentMax;
            }
            return Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), currentMax);
        });
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.inputTank.getStored(), this.inputTank.getCapacity());
    }

    public MachineEnergyContainer<TileEntityChemicalWasher> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableFloatingLong.create(() -> this.clientEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }
}

