/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.Nonnull;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.Mekanism;
import mekanism.common.content.sps.SPSMultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.particle.SPSOrbitEffect;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.NBTUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;

public class TileEntitySPSCasing
extends TileEntityMultiblock<SPSMultiblockData> {
    public final Queue<SPSOrbitEffect> orbitEffects = new LinkedList<SPSOrbitEffect>();
    private boolean handleSound;
    private boolean prevActive;

    public TileEntitySPSCasing() {
        super(MekanismBlocks.SPS_CASING);
    }

    public TileEntitySPSCasing(IBlockProvider provider) {
        super(provider);
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        this.orbitEffects.removeIf(effect -> !this.isMaster || effect.tick());
    }

    @Override
    protected void onUpdateServer(SPSMultiblockData multiblock) {
        boolean active;
        super.onUpdateServer(multiblock);
        boolean bl = active = multiblock.isFormed() && multiblock.handlesSound(this) && multiblock.lastProcessed > 0.0;
        if (active != this.prevActive) {
            this.prevActive = active;
            this.sendUpdatePacket();
        }
    }

    @Override
    public SPSMultiblockData createMultiblock() {
        return new SPSMultiblockData(this);
    }

    @Override
    public MultiblockManager<SPSMultiblockData> getManager() {
        return Mekanism.spsManager;
    }

    @Override
    protected boolean canPlaySound() {
        SPSMultiblockData multiblock = (SPSMultiblockData)this.getMultiblock();
        return multiblock.isFormed() && multiblock.lastProcessed > 0.0 && this.handleSound;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        SPSMultiblockData multiblock = (SPSMultiblockData)this.getMultiblock();
        updateTag.func_74757_a("handleSound", multiblock.isFormed() && multiblock.handlesSound(this));
        if (multiblock.isFormed()) {
            updateTag.func_74780_a("lastProcessed", multiblock.lastProcessed);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setBooleanIfPresent(tag, "handleSound", value -> {
            this.handleSound = value;
        });
        SPSMultiblockData multiblock = (SPSMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            multiblock.lastProcessed = tag.func_74769_h("lastProcessed");
        }
    }
}

