/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackGasToItemStackCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.upgrade.AdvancedMachineUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.item.ItemStack;

public abstract class TileEntityAdvancedElectricMachine
extends TileEntityProgressMachine<ItemStackGasToItemStackRecipe> {
    public static final int BASE_TICKS_REQUIRED = 200;
    public static final long MAX_GAS = 210L;
    private double gasUsage = 1.0;
    public IGasTank gasTank;
    protected final IOutputHandler<@NonNull ItemStack> outputHandler;
    protected final IInputHandler<@NonNull ItemStack> itemInputHandler;
    protected final ILongInputHandler<@NonNull GasStack> gasInputHandler;
    private MachineEnergyContainer<TileEntityAdvancedElectricMachine> energyContainer;
    private InputInventorySlot inputSlot;
    private OutputInventorySlot outputSlot;
    private GasInventorySlot secondarySlot;
    private EnergyInventorySlot energySlot;

    public TileEntityAdvancedElectricMachine(IBlockProvider blockProvider, int ticksRequired) {
        super(blockProvider, ticksRequired);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.ENERGY);
        this.configComponent.setupItemIOExtraConfig(this.inputSlot, this.outputSlot, this.secondarySlot, this.energySlot);
        this.configComponent.setupInputConfig(TransmissionType.GAS, this.gasTank);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM);
        this.itemInputHandler = InputHelper.getInputHandler(this.inputSlot);
        this.gasInputHandler = InputHelper.getInputHandler(this.gasTank);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputSlot);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        this.gasTank = ChemicalTankBuilder.GAS.input(210L, gas -> this.containsRecipe(recipe -> ((GasStackIngredient)recipe.getChemicalInput()).testType(gas)), this);
        builder.addTank(this.gasTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.inputSlot = InputInventorySlot.at(item -> this.containsRecipe(recipe -> recipe.getItemInput().testType(item)), this, 64, 17);
        builder.addSlot(this.inputSlot);
        this.secondarySlot = GasInventorySlot.fillOrConvert(this.gasTank, () -> ((TileEntityAdvancedElectricMachine)this).func_145831_w(), this, 64, 53);
        builder.addSlot(this.secondarySlot);
        this.outputSlot = OutputInventorySlot.at(this, 116, 35);
        builder.addSlot(this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityAdvancedElectricMachine)this).func_145831_w(), this, 39, 35);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        this.energySlot.fillContainerOrConvert();
        this.secondarySlot.fillTankOrConvert();
        this.cachedRecipe = this.getUpdatedCache(0);
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
        }
    }

    public boolean useStatisticalMechanics() {
        return false;
    }

    @Override
    @Nullable
    public CachedRecipe<ItemStackGasToItemStackRecipe> getCachedRecipe(int cacheIndex) {
        return this.cachedRecipe;
    }

    @Override
    @Nullable
    public ItemStackGasToItemStackRecipe getRecipe(int cacheIndex) {
        ItemStack stack = this.itemInputHandler.getInput();
        if (stack.func_190926_b()) {
            return null;
        }
        GasStack gasStack = (GasStack)this.gasInputHandler.getInput();
        if (gasStack.isEmpty()) {
            return null;
        }
        return (ItemStackGasToItemStackRecipe)this.findFirstRecipe(recipe -> recipe.test(stack, gasStack));
    }

    @Override
    @Nullable
    public CachedRecipe<ItemStackGasToItemStackRecipe> createNewCachedRecipe(@Nonnull ItemStackGasToItemStackRecipe recipe, int cacheIndex) {
        LongSupplier gasUsageMultiplier = this.useStatisticalMechanics() ? () -> StatUtils.inversePoisson(this.gasUsage) : () -> MathUtils.clampToLong(Math.ceil(this.gasUsage));
        return new ItemStackGasToItemStackCachedRecipe<ItemStackGasToItemStackRecipe>(recipe, this.itemInputHandler, this.gasInputHandler, gasUsageMultiplier, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(() -> this.ticksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(this::setOperatingTicks);
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED || upgrade == Upgrade.GAS && this.getSupportedUpgrade().contains(Upgrade.GAS)) {
            this.gasUsage = MekanismUtils.getGasPerTickMeanMultiplier(this);
        }
    }

    @Override
    @Nonnull
    public AdvancedMachineUpgradeData getUpgradeData() {
        return new AdvancedMachineUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.getOperatingTicks(), this.gasTank, this.secondarySlot, this.energySlot, this.inputSlot, this.outputSlot, this.getComponents());
    }

    public MachineEnergyContainer<TileEntityAdvancedElectricMachine> getEnergyContainer() {
        return this.energyContainer;
    }
}

