/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.common.content.network.transmitter.LogisticalTransporter;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class TransporterUtils {
    public static final List<EnumColor> colors = Arrays.asList(EnumColor.DARK_BLUE, EnumColor.DARK_GREEN, EnumColor.DARK_AQUA, EnumColor.DARK_RED, EnumColor.PURPLE, EnumColor.INDIGO, EnumColor.BRIGHT_GREEN, EnumColor.AQUA, EnumColor.RED, EnumColor.PINK, EnumColor.YELLOW, EnumColor.BLACK);

    private TransporterUtils() {
    }

    @Nullable
    public static EnumColor readColor(int inputColor) {
        return inputColor == -1 ? null : colors.get(inputColor);
    }

    public static int getColorIndex(@Nullable EnumColor color) {
        return color == null ? -1 : colors.indexOf(color);
    }

    public static boolean isValidAcceptorOnSide(TileEntity tile, Direction side) {
        if (tile instanceof TileEntityTransmitter && TransmissionType.ITEM.checkTransmissionType((TileEntityTransmitter)tile)) {
            return false;
        }
        return InventoryUtils.isItemHandler(tile, side.func_176734_d());
    }

    public static EnumColor increment(EnumColor color) {
        if (color == null) {
            return colors.get(0);
        }
        int index = colors.indexOf(color);
        return index == colors.size() - 1 ? null : colors.get(index + 1);
    }

    public static EnumColor decrement(EnumColor color) {
        if (color == null) {
            return colors.get(colors.size() - 1);
        }
        int index = colors.indexOf(color);
        return index == 0 ? null : colors.get(index - 1);
    }

    public static void drop(LogisticalTransporterBase transporter, TransporterStack stack) {
        BlockPos blockPos = transporter.getTilePos();
        if (stack.hasPath()) {
            float[] pos = TransporterUtils.getStackPosition(transporter, stack, 0.0f);
            blockPos = blockPos.func_177963_a((double)pos[0], (double)pos[1], (double)pos[2]);
        }
        TransporterManager.remove(transporter.getTileWorld(), stack);
        Block.func_180635_a((World)transporter.getTileWorld(), (BlockPos)blockPos, (ItemStack)stack.itemStack);
    }

    public static float[] getStackPosition(LogisticalTransporterBase transporter, TransporterStack stack, float partial) {
        Direction side = stack.getSide(transporter);
        float progress = ((float)stack.progress + partial) / 100.0f - 0.5f;
        return new float[]{0.5f + (float)side.func_82601_c() * progress, 0.25f + (float)side.func_96559_d() * progress, 0.5f + (float)side.func_82599_e() * progress};
    }

    public static void incrementColor(LogisticalTransporter tile) {
        EnumColor color = tile.getColor();
        if (color == null) {
            tile.setColor(colors.get(0));
        } else {
            int index = colors.indexOf(color);
            if (index == colors.size() - 1) {
                tile.setColor(null);
            } else {
                tile.setColor(colors.get(index + 1));
            }
        }
    }

    public static boolean canInsert(TileEntity tile, EnumColor color, ItemStack itemStack, Direction side, boolean force) {
        Optional capability;
        ISideConfiguration config;
        if (force && tile instanceof TileEntityLogisticalSorter) {
            return ((TileEntityLogisticalSorter)tile).canSendHome(itemStack);
        }
        if (!force && tile instanceof ISideConfiguration && (config = (ISideConfiguration)tile).getEjector().hasStrictInput()) {
            Direction tileSide = config.getOrientation();
            EnumColor configColor = config.getEjector().getInputColor(RelativeSide.fromDirections(tileSide, side.func_176734_d()));
            if (configColor != null && configColor != color) {
                return false;
            }
        }
        if ((capability = CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d()).resolve()).isPresent()) {
            IItemHandler inventory = (IItemHandler)capability.get();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack rejects;
                if (!inventory.isItemValid(i, itemStack) || !TransporterManager.didEmit(itemStack, rejects = inventory.insertItem(i, itemStack, true))) continue;
                return true;
            }
        }
        return false;
    }
}

