/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore;

import com.mrdimka.hammercore.RayCubeRegistry;
import com.mrdimka.hammercore.annotations.MCFBus;
import com.mrdimka.hammercore.api.HammerCoreAPI;
import com.mrdimka.hammercore.api.IHammerCoreAPI;
import com.mrdimka.hammercore.api.IJavaCode;
import com.mrdimka.hammercore.api.IUpdatable;
import com.mrdimka.hammercore.api.RequiredDeps;
import com.mrdimka.hammercore.api.WrappedFMLLog;
import com.mrdimka.hammercore.api.mhb.IRayRegistry;
import com.mrdimka.hammercore.api.mhb.RaytracePlugin;
import com.mrdimka.hammercore.asm.CSVFile;
import com.mrdimka.hammercore.cfg.ConfigHolder;
import com.mrdimka.hammercore.cfg.HCModConfigurations;
import com.mrdimka.hammercore.cfg.IConfigReloadListener;
import com.mrdimka.hammercore.command.CommandBuildStructure;
import com.mrdimka.hammercore.command.CommandLoadChunk;
import com.mrdimka.hammercore.command.CommandPosToLong;
import com.mrdimka.hammercore.command.CommandTPX;
import com.mrdimka.hammercore.command.CommandTimeToTicks;
import com.mrdimka.hammercore.common.capabilities.CapabilityEJ;
import com.mrdimka.hammercore.common.utils.AnnotatedInstanceUtil;
import com.mrdimka.hammercore.common.utils.HammerCoreUtils;
import com.mrdimka.hammercore.common.utils.IOUtils;
import com.mrdimka.hammercore.common.utils.WrappedLog;
import com.mrdimka.hammercore.event.AddCalculatronRecipeEvent;
import com.mrdimka.hammercore.event.GetAllRequiredApisEvent;
import com.mrdimka.hammercore.ext.TeslaAPI;
import com.mrdimka.hammercore.fluiddict.FluidDictionary;
import com.mrdimka.hammercore.gui.GuiManager;
import com.mrdimka.hammercore.init.ModBlocks;
import com.mrdimka.hammercore.init.ModItems;
import com.mrdimka.hammercore.init.SimpleRegistration;
import com.mrdimka.hammercore.net.HCNetwork;
import com.mrdimka.hammercore.proxy.AudioProxy_Common;
import com.mrdimka.hammercore.proxy.BookProxy_Common;
import com.mrdimka.hammercore.proxy.LightProxy_Common;
import com.mrdimka.hammercore.proxy.ParticleProxy_Common;
import com.mrdimka.hammercore.proxy.PipelineProxy_Common;
import com.mrdimka.hammercore.proxy.RenderProxy_Common;
import com.mrdimka.hammercore.recipeAPI.BrewingRecipe;
import com.mrdimka.hammercore.recipeAPI.IRecipePlugin;
import com.mrdimka.hammercore.recipeAPI.RecipePlugin;
import com.mrdimka.hammercore.recipeAPI.registry.GlobalRecipeScript;
import com.mrdimka.hammercore.recipeAPI.registry.RecipeTypeRegistry;
import com.mrdimka.hammercore.recipeAPI.registry.SimpleRecipeScript;
import com.mrdimka.hammercore.structure.StructureAPI;
import com.mrdimka.hammercore.world.WorldGenHammerCore;
import com.pengu.hammercore.common.chunk.ChunkLoaderHC;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="hammercore", version="1.9.3.9", name="Hammer Core", guiFactory="com.mrdimka.hammercore.cfg.gui.GuiConfigFactory", acceptedMinecraftVersions="[1.11.2]")
public class HammerCore {
    public static final List<String> initHCChannels = new ArrayList<String>();
    public static final boolean IS_OBFUSCATED_MC = true;
    @SidedProxy(modId="hammercore", clientSide="com.mrdimka.hammercore.proxy.RenderProxy_Client", serverSide="com.mrdimka.hammercore.proxy.RenderProxy_Common")
    public static RenderProxy_Common renderProxy;
    @SidedProxy(modId="hammercore", clientSide="com.mrdimka.hammercore.proxy.AudioProxy_Client", serverSide="com.mrdimka.hammercore.proxy.AudioProxy_Common")
    public static AudioProxy_Common audioProxy;
    @SidedProxy(modId="hammercore", clientSide="com.mrdimka.hammercore.proxy.ParticleProxy_Client", serverSide="com.mrdimka.hammercore.proxy.ParticleProxy_Common")
    public static ParticleProxy_Common particleProxy;
    @SidedProxy(modId="hammercore", clientSide="com.mrdimka.hammercore.proxy.LightProxy_Client", serverSide="com.mrdimka.hammercore.proxy.LightProxy_Common")
    public static LightProxy_Common lightProxy;
    @SidedProxy(modId="hammercore", clientSide="com.mrdimka.hammercore.proxy.BookProxy_Client", serverSide="com.mrdimka.hammercore.proxy.BookProxy_Common")
    public static BookProxy_Common bookProxy;
    @SidedProxy(modId="hammercore", clientSide="com.mrdimka.hammercore.proxy.PipelineProxy_Client", serverSide="com.mrdimka.hammercore.proxy.PipelineProxy_Common")
    public static PipelineProxy_Common pipelineProxy;
    @Mod.Instance(value="hammercore")
    public static HammerCore instance;
    public static final CreativeTabs tab;
    public static final Map<IHammerCoreAPI, HammerCoreAPI> APIS;
    public static final Set<IJavaCode> COMPILED_CODES;
    public static final WrappedLog LOG;
    public static final CSVFile FIELD_CSV;
    public static final CSVFile METHODS_CSV;
    private List<IRayRegistry> raytracePlugins;
    private List<IRecipePlugin> recipePlugins;
    private List<ConfigHolder> configListeners;
    public static final RecipeTypeRegistry registry;
    private GlobalRecipeScript recipeScript;
    public static final List<IUpdatable> updatables;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent e) {
        renderProxy.construct();
        audioProxy.construct();
        if (!FluidRegistry.isUniversalBucketEnabled()) {
            FluidRegistry.enableUniversalBucket();
        }
        new FluidDictionary();
        initHCChannels.add("particles");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        List<IHammerCoreAPI> apis = AnnotatedInstanceUtil.getInstances(e.getAsmData(), HammerCoreAPI.class, IHammerCoreAPI.class);
        List<Object> toRegister = AnnotatedInstanceUtil.getInstances(e.getAsmData(), MCFBus.class, Object.class);
        List<IConfigReloadListener> listeners = AnnotatedInstanceUtil.getInstances(e.getAsmData(), HCModConfigurations.class, IConfigReloadListener.class);
        toRegister.add(this);
        for (IJavaCode code : COMPILED_CODES) {
            code.addMCFObjects(toRegister);
        }
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Loading", (int)(3 + apis.size() + toRegister.size() + listeners.size()));
        bar.step("Registering EJ");
        CapabilityEJ.register();
        this.configListeners = new ArrayList<ConfigHolder>();
        int i = 0;
        for (IConfigReloadListener listener : listeners) {
            bar.step("Registering Custom Configs (" + ++i + "/" + listeners.size() + ")");
            ConfigHolder h = new ConfigHolder(listener, new Configuration(listener.getSuggestedConfigurationFile()));
            h.reload();
            this.configListeners.add(h);
            LOG.info("Added \"" + listener.getClass().getName() + "\" to Hammer Core Simple Configs.", new Object[0]);
        }
        this.raytracePlugins = AnnotatedInstanceUtil.getInstances(e.getAsmData(), RaytracePlugin.class, IRayRegistry.class);
        this.recipePlugins = AnnotatedInstanceUtil.getInstances(e.getAsmData(), RecipePlugin.class, IRecipePlugin.class);
        i = 0;
        for (Object o : toRegister) {
            bar.step("Registering Objects to Event Bus (" + ++i + "/" + toRegister.size() + ")");
            MinecraftForge.EVENT_BUS.register(o);
            LOG.info("Added \"" + o + "\" to MCF Event Bus.", new Object[0]);
        }
        LOG.info("Added " + toRegister.size() + " object to MCF Event Bus.", new Object[0]);
        GetAllRequiredApisEvent evt = new GetAllRequiredApisEvent();
        MinecraftForge.EVENT_BUS.post((Event)evt);
        RequiredDeps.addRequests(evt);
        i = 0;
        for (IHammerCoreAPI api : apis) {
            bar.step("Registering external libraries (" + ++i + "/" + apis.size() + ")");
            HammerCoreAPI apia = api.getClass().getAnnotation(HammerCoreAPI.class);
            if (apia == null) continue;
            WrappedFMLLog log = new WrappedFMLLog(apia.name());
            api.init(log, apia.version());
            APIS.put(api, apia);
        }
        bar.step("Registering Blocks");
        SimpleRegistration.registerFieldBlocksFrom(ModBlocks.class, "hammercore", tab);
        bar.step("Registering Items");
        SimpleRegistration.registerFieldItemsFrom(ModItems.class, "hammercore", tab);
        ModMetadata meta = e.getModMetadata();
        meta.autogenerated = false;
        meta.version = "1.9.3.9";
        meta.authorList = Arrays.asList("APengu");
        for (IJavaCode code : COMPILED_CODES) {
            code.preInit();
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        renderProxy.init();
        bookProxy.init();
        HCNetwork.clinit();
        for (IJavaCode code : COMPILED_CODES) {
            code.init();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiManager());
        AddCalculatronRecipeEvent evt = new AddCalculatronRecipeEvent();
        evt.setRecipe((IRecipe)new ShapedOreRecipe(ModItems.calculatron, new Object[]{"igi", "rlr", "idi", Character.valueOf('g'), "blockGlass", Character.valueOf('i'), "ingotIron", Character.valueOf('r'), "dustRedstone", Character.valueOf('d'), "ingotGold", Character.valueOf('l'), "dyeLime"}));
        if (!MinecraftForge.EVENT_BUS.post((Event)evt)) {
            GameRegistry.addRecipe((IRecipe)evt.getRecipe());
        }
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)BrewingRecipe.INSTANCE);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenHammerCore(), (int)0);
        StructureAPI.registerSpawnableStructure(new ResourceLocation("hammercore", "well"));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        for (IJavaCode code : COMPILED_CODES) {
            code.postInit();
        }
        for (IRecipePlugin plugin : this.recipePlugins) {
            LOG.info("Registering recipe plugin: " + plugin.getClass().getName() + " ...", new Object[0]);
            long start = System.currentTimeMillis();
            plugin.registerTypes(registry);
            LOG.info("Registered recipe  plugin: " + plugin.getClass().getName() + " in " + (System.currentTimeMillis() - start) + " ms", new Object[0]);
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandPosToLong());
        e.registerServerCommand((ICommand)new CommandTPX());
        e.registerServerCommand((ICommand)new CommandBuildStructure());
        e.registerServerCommand((ICommand)new CommandTimeToTicks());
        e.registerServerCommand((ICommand)new CommandLoadChunk());
        File hc_recipes_global = new File("hc-recipes");
        MinecraftServer server = e.getServer();
        File worldFolder = new File((server.func_71262_S() ? "" : "saves" + File.separator) + server.func_71270_I(), "hc-recipes");
        worldFolder.mkdirs();
        hc_recipes_global.mkdirs();
        if (this.recipeScript != null) {
            this.recipeScript.remove();
        }
        ArrayList<SimpleRecipeScript> scripts = new ArrayList<SimpleRecipeScript>();
        scripts.addAll(Arrays.asList(this.parse((File)worldFolder).scripts));
        scripts.addAll(Arrays.asList(this.parse((File)hc_recipes_global).scripts));
        this.recipeScript = new GlobalRecipeScript(scripts.toArray(new SimpleRecipeScript[scripts.size()]));
        GRCProvider.reloadScript();
        this.reloadRaytracePlugins();
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent evt) {
        if (evt.side == Side.SERVER) {
            ChunkLoaderHC.INSTANCE.update();
            for (int i = 0; i < updatables.size(); ++i) {
                try {
                    IUpdatable upd = updatables.get(i);
                    upd.update();
                    if (upd.isAlive()) continue;
                    updatables.remove(i);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public int hashCode() {
        return 0x666666;
    }

    @SubscribeEvent
    public void configReloaded(ConfigChangedEvent evt) {
        String mid = evt.getModID();
        for (ConfigHolder holder : this.configListeners) {
            if (!holder.listener.getModid().equals(mid)) continue;
            holder.reload();
        }
    }

    public void reloadRaytracePlugins() {
        TeslaAPI.refreshTeslaClassData();
        RayCubeRegistry.instance.cubes.clear();
        RayCubeRegistry.instance.mgrs.clear();
        for (IRayRegistry reg : this.raytracePlugins) {
            LOG.info("Registering raytrace plugin: " + reg.getClass().getName() + " ...", new Object[0]);
            long start = System.currentTimeMillis();
            reg.registerCubes(RayCubeRegistry.instance);
            LOG.info("Registered raytrace  plugin: " + reg.getClass().getName() + " in " + (System.currentTimeMillis() - start) + " ms", new Object[0]);
        }
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent evt) {
        if (this.recipeScript != null) {
            this.recipeScript.remove();
        }
        this.recipeScript = null;
        ChunkLoaderHC.INSTANCE.isAlive();
    }

    private GlobalRecipeScript parse(File path) {
        if (path.isDirectory()) {
            ArrayList<SimpleRecipeScript> jsons = new ArrayList<SimpleRecipeScript>();
            for (File json : path.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".json");
                }
            })) {
                try {
                    jsons.add(registry.parse(new String(IOUtils.pipeOut(new FileInputStream(json)))));
                }
                catch (Throwable err) {
                    LOG.bigWarn("Failed to parse HammerCoreRecipeJson File:", new Object[0]);
                    err.printStackTrace();
                }
            }
            return new GlobalRecipeScript(jsons.toArray(new SimpleRecipeScript[jsons.size()]));
        }
        if (path.isFile()) {
            try {
                return new GlobalRecipeScript(registry.parse(new String(IOUtils.pipeOut(new FileInputStream(path)))));
            }
            catch (Throwable err) {
                LOG.bigWarn("Failed to parse HammerCoreRecipeJson File:", new Object[0]);
                err.printStackTrace();
            }
        }
        return new GlobalRecipeScript(new SimpleRecipeScript[0]);
    }

    static {
        tab = HammerCoreUtils.createDynamicCreativeTab("hammercore", 60);
        APIS = new HashMap<IHammerCoreAPI, HammerCoreAPI>();
        COMPILED_CODES = new HashSet<IJavaCode>();
        LOG = new WrappedLog("Hammer Core");
        CSVFile f = null;
        CSVFile m = null;
        f = new CSVFile(HammerCore.class.getResourceAsStream("/fields.csv"));
        m = new CSVFile(HammerCore.class.getResourceAsStream("/methods.csv"));
        FIELD_CSV = f;
        METHODS_CSV = m;
        registry = new RecipeTypeRegistry();
        updatables = new ArrayList<IUpdatable>(4);
    }

    public static class GRCProvider {
        public static int getScriptCount() {
            return ((HammerCore)HammerCore.instance).recipeScript.scripts.length;
        }

        public static void setScriptCount(int amt) {
            if (amt == 0 && instance.recipeScript != null) {
                instance.recipeScript.remove();
                instance.recipeScript = null;
                return;
            }
            if (instance.recipeScript == null) {
                instance.recipeScript = new GlobalRecipeScript(new SimpleRecipeScript[0]);
            }
            instance.recipeScript.remove();
            SimpleRecipeScript[] old = ((HammerCore)HammerCore.instance).recipeScript.scripts;
            if (old.length == amt) {
                return;
            }
            ((HammerCore)HammerCore.instance).recipeScript.scripts = new SimpleRecipeScript[amt];
            for (int i = 0; i < Math.min(old.length, amt); ++i) {
                ((HammerCore)HammerCore.instance).recipeScript.scripts[i] = old[i];
            }
        }

        public static NBTTagList getScript(int id) {
            if (instance.recipeScript == null) {
                return new NBTTagList();
            }
            return id >= ((HammerCore)HammerCore.instance).recipeScript.scripts.length && ((HammerCore)HammerCore.instance).recipeScript.scripts[id].makeTag != null ? null : ((HammerCore)HammerCore.instance).recipeScript.scripts[id].makeTag.func_74737_b();
        }

        public static void setScript(int id, NBTTagList list) {
            if (instance.recipeScript == null) {
                instance.recipeScript = new GlobalRecipeScript(new SimpleRecipeScript[0]);
            }
            instance.recipeScript.remove();
            GRCProvider.setScriptCount(Math.max(((HammerCore)HammerCore.instance).recipeScript.scripts.length, id + 1));
            ((HammerCore)HammerCore.instance).recipeScript.scripts[id] = registry.parse(list);
        }

        public static void reloadScript() {
            if (instance.recipeScript != null) {
                instance.recipeScript.remove();
                instance.recipeScript.add();
            }
        }
    }
}

