/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.api.dynlight;

import com.mrdimka.hammercore.api.dynlight.IDynlightSrc;
import com.mrdimka.hammercore.api.dynlight.IMovable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;

public class DynLightContainer {
    private final IDynlightSrc src;
    private int x;
    private int y;
    private int z;
    private int prevX;
    private int prevY;
    private int prevZ;

    public DynLightContainer(IDynlightSrc src) {
        this.src = src;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public IDynlightSrc getLightSource() {
        return this.src;
    }

    public boolean update() {
        IMovable mov = this.src.getSrcInfo();
        if (mov == null || !mov.isAlive()) {
            return false;
        }
        if (this.hasSrcMoved(mov)) {
            mov.getWorld().func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(this.x, this.y, this.z));
            mov.getWorld().func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(this.prevX, this.prevY, this.prevZ));
        }
        return true;
    }

    private boolean hasSrcMoved(IMovable mov) {
        int nx = mov.getX();
        int ny = mov.getY();
        int nz = mov.getZ();
        if (this.x != nx || this.y != ny || this.z != nz) {
            this.prevX = this.x;
            this.prevY = this.y;
            this.prevZ = this.z;
            this.x = nx;
            this.y = ny;
            this.z = nz;
            return true;
        }
        return false;
    }
}

