/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.api.dynlight;

import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.api.dynlight.DynLightContainer;
import com.mrdimka.hammercore.api.dynlight.IDynlightSrc;
import com.mrdimka.hammercore.proxy.ParticleProxy_Client;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DynamicLightGetter {
    private static IBlockAccess lastWorld;
    private static ConcurrentLinkedQueue<DynLightContainer> lastList;
    private static ConcurrentHashMap<World, ConcurrentLinkedQueue<DynLightContainer>> worldLightsMap;

    public static int getLightValue(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        int vanillaValue = blockState.getLightValue(world, pos);
        if (world instanceof WorldServer) {
            return vanillaValue;
        }
        if (!world.equals(lastWorld) || lastList == null) {
            lastWorld = world;
            lastList = worldLightsMap.get(world);
            DynamicLightGetter.hackRenderGlobalConcurrently();
        }
        int dynamicValue = 0;
        if (lastList != null && !lastList.isEmpty()) {
            for (DynLightContainer light : lastList) {
                if (light.getX() != pos.func_177958_n() || light.getY() != pos.func_177956_o() || light.getZ() != pos.func_177952_p()) continue;
                dynamicValue = Math.max(dynamicValue, light.getLightSource().getLightLevel());
            }
        }
        return Math.max(vanillaValue, dynamicValue);
    }

    private static void hackRenderGlobalConcurrently() {
        try {
            for (Field f : RenderGlobal.class.getDeclaredFields()) {
                ParameterizedType fieldType;
                if (!Set.class.isAssignableFrom(f.getType()) || !BlockPos.class.equals((Object)(fieldType = (ParameterizedType)f.getGenericType()).getActualTypeArguments()[0])) continue;
                f.setAccessible(true);
                Set setLightUpdates = (Set)f.get(Minecraft.func_71410_x().field_71438_f);
                if (setLightUpdates instanceof ConcurrentSkipListSet) {
                    return;
                }
                ConcurrentSkipListSet cs = new ConcurrentSkipListSet(setLightUpdates);
                f.set(Minecraft.func_71410_x().field_71438_f, cs);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent tick) {
        ConcurrentLinkedQueue<DynLightContainer> worldLights;
        if (HammerCore.particleProxy instanceof ParticleProxy_Client) {
            ((ParticleProxy_Client)HammerCore.particleProxy).clientTick(tick);
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (tick.phase == TickEvent.Phase.END && mc.field_71441_e != null && (worldLights = worldLightsMap.get(mc.field_71441_e)) != null) {
            Iterator<DynLightContainer> iter = worldLights.iterator();
            while (iter.hasNext()) {
                DynLightContainer tickedLightContainer = iter.next();
                if (tickedLightContainer.update()) continue;
                iter.remove();
                mc.field_71441_e.func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(tickedLightContainer.getX(), tickedLightContainer.getY(), tickedLightContainer.getZ()));
            }
        }
    }

    public static void addLightSource(IDynlightSrc lightToAdd) {
        if (lightToAdd.getSrcInfo() != null && lightToAdd.getSrcInfo().isAlive()) {
            DynLightContainer newLightContainer = new DynLightContainer(lightToAdd);
            ConcurrentLinkedQueue<DynLightContainer> lightList = worldLightsMap.get(lightToAdd.getSrcInfo().getWorld());
            if (lightList != null) {
                if (!lightList.contains(newLightContainer)) {
                    lightList.add(newLightContainer);
                }
            } else {
                lightList = new ConcurrentLinkedQueue();
                lightList.add(newLightContainer);
                worldLightsMap.put(lightToAdd.getSrcInfo().getWorld(), lightList);
            }
        }
    }

    public static void removeLightSource(IDynlightSrc lightToRemove) {
        World world;
        if (lightToRemove != null && lightToRemove.getSrcInfo() != null && (world = lightToRemove.getSrcInfo().getWorld()) != null) {
            DynLightContainer iterContainer = null;
            ConcurrentLinkedQueue<DynLightContainer> lightList = worldLightsMap.get(world);
            if (lightList != null) {
                Iterator<DynLightContainer> iter = lightList.iterator();
                while (iter.hasNext()) {
                    iterContainer = iter.next();
                    if (!iterContainer.getLightSource().equals(lightToRemove)) continue;
                    iter.remove();
                    break;
                }
                if (iterContainer != null) {
                    world.func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(iterContainer.getX(), iterContainer.getY(), iterContainer.getZ()));
                }
            }
        }
    }

    static {
        worldLightsMap = new ConcurrentHashMap();
    }
}

