/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.api.dynlight;

import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IMovable {
    public int getX();

    public int getY();

    public int getZ();

    public World getWorld();

    public boolean isAlive();

    public static class EntityMovable
    implements IMovable {
        private Entity entity;

        public EntityMovable(Entity ent) {
            this.entity = ent;
        }

        @Override
        public World getWorld() {
            return this.entity.field_70170_p;
        }

        @Override
        public int getX() {
            return (int)Math.floor(this.entity.field_70165_t);
        }

        @Override
        public int getY() {
            return (int)Math.floor(this.entity.field_70163_u);
        }

        @Override
        public int getZ() {
            return (int)Math.floor(this.entity.field_70161_v);
        }

        public void setEntity(Entity entity) {
            this.entity = entity;
        }

        public Entity getEntity() {
            return this.entity;
        }

        @Override
        public boolean isAlive() {
            return this.entity != null && !this.entity.field_70128_L;
        }
    }

    public static class BlockMovable
    implements IMovable {
        public BlockPos pos;
        public World world;
        public boolean isAlive = true;

        public BlockMovable(BlockPos pos, World world) {
            this.pos = pos;
        }

        public void setPos(BlockPos pos) {
            this.pos = pos;
        }

        public void setWorld(World world) {
            this.world = world;
        }

        @Override
        public int getX() {
            return this.pos.func_177958_n();
        }

        @Override
        public int getY() {
            return this.pos.func_177956_o();
        }

        @Override
        public int getZ() {
            return this.pos.func_177952_p();
        }

        @Override
        public World getWorld() {
            return this.world;
        }

        @Override
        public boolean isAlive() {
            return this.isAlive;
        }
    }
}

