/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.api.explosion;

import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.api.IUpdatable;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CustomExplosion
implements IUpdatable {
    private World worldObj;
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private float power;
    private Random random = new Random();
    private final DamageSource entityDamageSource;
    private double expansion = 0.0;
    private boolean isDead = false;

    public CustomExplosion(World world, int x, int y, int z, float power, DamageSource entityDamageSource) {
        this.entityDamageSource = entityDamageSource;
        this.worldObj = world;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.power = power;
        this.isDead = world.field_72995_K;
    }

    public static boolean doExplosionAt(World world, BlockPos pos, float power, DamageSource entityDamageSource) {
        if (world != null && world.func_175667_e(pos) && pos != null && !world.field_72995_K) {
            HammerCore.updatables.add(new CustomExplosion(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), power, entityDamageSource));
            return true;
        }
        return false;
    }

    public static double getDistanceAtoB(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }

    @Override
    public void update() {
        int OD = (int)this.expansion;
        int ID = OD - 1;
        int size = (int)this.expansion;
        for (int x = this.xCoord - size; x < this.xCoord + size; ++x) {
            for (int z = this.zCoord - size; z < this.zCoord + size; ++z) {
                double dist = CustomExplosion.getDistanceAtoB(x, z, this.xCoord, this.zCoord);
                if (!(dist < (double)OD) || !(dist >= (double)ID)) continue;
                float tracePower = this.power - (float)(this.expansion / 10.0);
                tracePower = (float)((double)tracePower * (1.0 + (double)(this.random.nextFloat() - 0.5f) * 0.2));
                HammerCore.updatables.add(new CustomExplosionTrace(this.worldObj, x, this.yCoord, z, tracePower, this.random));
            }
        }
        this.isDead = this.expansion >= (double)(this.power * 10.0f);
        this.expansion += 1.0;
    }

    @Override
    public boolean isAlive() {
        return !this.isDead;
    }

    public class CustomExplosionTrace
    implements IUpdatable {
        private World worldObj;
        private int xCoord;
        private int yCoord;
        private int zCoord;
        private float power;
        private Random random;
        private boolean isDead = false;

        public CustomExplosionTrace(World world, int x, int y, int z, float power, Random random) {
            this.worldObj = world;
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            this.power = power;
            this.random = random;
        }

        @Override
        public void update() {
            List entities;
            int y;
            float energy = this.power * 10.0f;
            if (!this.worldObj.func_175667_e(new BlockPos(this.xCoord, 16, this.zCoord))) {
                this.worldObj.func_175726_f(new BlockPos(this.xCoord, 16, this.zCoord));
            }
            for (y = this.yCoord; y >= 0 && energy > 0.0f; energy -= 0.5f + 0.1f * (float)(this.yCoord - y), --y) {
                entities = this.worldObj.func_72872_a(Entity.class, new AxisAlignedBB((double)this.xCoord, (double)y, (double)this.zCoord, (double)(this.xCoord + 1), (double)(y + 1), (double)(this.zCoord + 1)));
                if (CustomExplosion.this.entityDamageSource != null) {
                    for (Entity entity : entities) {
                        entity.func_70097_a(CustomExplosion.this.entityDamageSource, this.power * 100.0f);
                    }
                }
                if (!(energy >= 0.0f)) continue;
                this.worldObj.func_175698_g(new BlockPos(this.xCoord, y, this.zCoord));
            }
            energy = this.power * 20.0f;
            ++this.yCoord;
            for (y = this.yCoord; y < 255 && energy > 0.0f; energy -= 0.5f + 0.1f * (float)(y - this.yCoord), ++y) {
                entities = this.worldObj.func_72872_a(Entity.class, new AxisAlignedBB((double)this.xCoord, (double)y, (double)this.zCoord, (double)(this.xCoord + 1), (double)(y + 1), (double)(this.zCoord + 1)));
                if (CustomExplosion.this.entityDamageSource != null) {
                    for (Entity entity : entities) {
                        entity.func_70097_a(CustomExplosion.this.entityDamageSource, this.power * 100.0f);
                    }
                }
                if (!(energy >= 0.0f)) continue;
                this.worldObj.func_175698_g(new BlockPos(this.xCoord, y, this.zCoord));
            }
            this.isDead = true;
        }

        @Override
        public boolean isAlive() {
            return !this.isDead;
        }
    }
}

