/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.api.multipart;

import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.api.handlers.IHandlerProvider;
import com.mrdimka.hammercore.client.particle.ParticleDiggingState;
import com.mrdimka.hammercore.common.blocks.multipart.TileMultipart;
import com.mrdimka.hammercore.common.utils.WorldUtil;
import com.mrdimka.hammercore.proxy.ParticleProxy_Client;
import com.pengu.hammercore.net.utils.IPropertyChangeHandler;
import com.pengu.hammercore.net.utils.NetPropertyAbstract;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MultipartSignature
implements IPropertyChangeHandler {
    protected static final SecureRandom RANDOM = new SecureRandom();
    protected boolean reRenderRequired = false;
    protected TileMultipart owner;
    protected World world;
    protected BlockPos pos;
    protected IBlockState state;
    int changes = 0;
    final List<NetPropertyAbstract> properties = new ArrayList<NetPropertyAbstract>();

    public final void setOwner(TileMultipart owner) {
        this.owner = owner;
    }

    public final TileMultipart getOwner() {
        return this.owner;
    }

    public final void requestSync() {
        if (this.owner != null) {
            this.owner.sendChangesToNearby();
        }
    }

    public final IBlockState getState() {
        return this.state;
    }

    public final void setState(IBlockState state) {
        this.state = state;
    }

    public final void setWorld(World worldIn) {
        this.world = worldIn;
    }

    public final void setPos(BlockPos posIn) {
        this.pos = posIn;
    }

    public ItemStack getPickBlock(EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    public SoundType getSoundType(EntityPlayer player) {
        if (this.getState() != null) {
            return this.getState().func_177230_c().getSoundType(this.getState(), this.world, this.pos, (Entity)player);
        }
        return SoundType.field_185851_d;
    }

    protected float getMultipartHardness(EntityPlayer player) {
        return this.getState() != null ? this.getState().func_185887_b(this.world, this.pos) : 0.0f;
    }

    public float getHardness(EntityPlayer player) {
        float hardness = this.getMultipartHardness(player);
        if (hardness < 0.0f || this.getState() == null) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock((Block)this.getState().func_177230_c(), (EntityPlayer)player, (IBlockAccess)this.world, (BlockPos)this.pos)) {
            return player.getDigSpeed(this.getState(), this.pos) / hardness / 100.0f;
        }
        return player.getDigSpeed(this.getState(), this.pos) / hardness / 30.0f;
    }

    public IHandlerProvider getProvider(EnumFacing toFace) {
        IHandlerProvider provider = this.owner;
        if (this.world != null && this.world.func_175667_e(this.pos.func_177972_a(toFace))) {
            provider = WorldUtil.cast(this.world, IHandlerProvider.class);
        }
        return provider != null ? provider : this.owner;
    }

    public int getWeakPower(EnumFacing side) {
        return 0;
    }

    public int getStrongPower(EnumFacing side) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void addHitEffects(World worldObj, RayTraceResult target, ParticleManager manager) {
        IBlockState state = this.getState();
        if (state != null && state.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            int i = this.pos.func_177958_n();
            int j = this.pos.func_177956_o();
            int k = this.pos.func_177952_p();
            float f = 0.1f;
            AxisAlignedBB axisalignedbb = this.getBoundingBox();
            double d0 = (double)i + RANDOM.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
            double d1 = (double)j + RANDOM.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
            double d2 = (double)k + RANDOM.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
            EnumFacing side = target.field_178784_b;
            if (side == EnumFacing.DOWN) {
                d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
            }
            if (side == EnumFacing.UP) {
                d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
            }
            if (side == EnumFacing.NORTH) {
                d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
            }
            if (side == EnumFacing.SOUTH) {
                d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
            }
            if (side == EnumFacing.WEST) {
                d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
            }
            if (side == EnumFacing.EAST) {
                d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
            }
            ParticleProxy_Client.queueParticleSpawn(new ParticleDiggingState(worldObj, d0, d1, d2, 0.0, 0.0, 0.0, state).func_174846_a(this.pos).func_70543_e(0.2f).func_70541_f(0.6f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        int i = 4;
        if (this.getState() != null) {
            for (int j = 0; j < i; ++j) {
                for (int k = 0; k < i; ++k) {
                    for (int l = 0; l < i; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        ParticleProxy_Client.queueParticleSpawn((Particle)new ParticleDiggingState(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, this.getState()).func_174846_a(pos));
                    }
                }
            }
        }
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean canPlaceInto(TileMultipart tmp) {
        return tmp != null && tmp.canPlace_def(this);
    }

    public boolean canConnectRedstone(EnumFacing side) {
        return false;
    }

    public boolean onSignatureActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    public int getLightLevel() {
        return 0;
    }

    public final NBTTagCompound writeNBT(NBTTagCompound nbt) {
        NBTTagList props = new NBTTagList();
        for (NetPropertyAbstract prop : this.properties) {
            NBTTagCompound tag = new NBTTagCompound();
            prop.writeToNBT(tag);
            tag.func_74778_a("Class", prop.getClass().getName());
            tag.func_74768_a("Id", this.properties.indexOf(prop));
            props.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Properties", (NBTBase)props);
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        nbt.func_74782_a("Tags", (NBTBase)tag);
        return nbt;
    }

    public final void readNBT(NBTTagCompound nbt) {
        NBTTagList props = nbt.func_150295_c("Properties", 10);
        for (int i = 0; i < props.func_74745_c(); ++i) {
            try {
                NBTTagCompound tag = props.func_150305_b(i);
                int id = tag.func_74762_e("Id");
                if (this.properties.size() <= id) continue;
                NetPropertyAbstract prop = this.properties.get(id);
                prop.readFromNBT(tag);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.readFromNBT(nbt.func_74775_l("Tags"));
    }

    public void writeToNBT(NBTTagCompound nbt) {
    }

    public void readFromNBT(NBTTagCompound nbt) {
    }

    public abstract AxisAlignedBB getBoundingBox();

    public boolean doesMindCollision(AxisAlignedBB otherAABB, AxisAlignedBB collisionAABB) {
        return true;
    }

    public static MultipartSignature createAndLoadSignature(NBTTagCompound nbt) {
        try {
            MultipartSignature signature = (MultipartSignature)Class.forName(nbt.func_74779_i("class")).newInstance();
            signature.readSignature(nbt);
            return signature;
        }
        catch (Throwable err) {
            HammerCore.LOG.error("Failed to load signature for " + nbt.func_74779_i("class") + "! This is a bug!", new Object[0]);
            err.printStackTrace();
            return null;
        }
    }

    public void onRemoved(boolean spawnDrop) {
        if (spawnDrop && !this.world.field_72995_K && this.state != null) {
            for (ItemStack stack : this.state.func_177230_c().getDrops((IBlockAccess)this.world, this.pos, this.state, 0)) {
                WorldUtil.spawnItemStack(this.world, this.pos, stack);
            }
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
    }

    public final NBTTagCompound writeSignature(NBTTagCompound nbt) {
        nbt.func_74778_a("class", this.getClass().getName());
        if (this.state != null) {
            nbt.func_74778_a("block", this.state.func_177230_c().getRegistryName().toString());
            nbt.func_74768_a("meta", this.state.func_177230_c().func_176201_c(this.state));
        }
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        nbt.func_74782_a("nbt", (NBTBase)tag);
        return nbt;
    }

    public final void readSignature(NBTTagCompound nbt) {
        if (nbt.func_150297_b("block", 8) && nbt.func_150297_b("meta", 3)) {
            this.state = ((Block)GameRegistry.findRegistry(Block.class).getValue(new ResourceLocation(nbt.func_74779_i("block")))).func_176203_a(nbt.func_74762_e("meta"));
        }
        this.pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        this.readFromNBT(nbt.func_74775_l("nbt"));
    }

    @Override
    public int registerProperty(NetPropertyAbstract prop) {
        if (this.properties.contains(prop)) {
            return this.properties.indexOf(prop);
        }
        this.properties.add(prop);
        return this.properties.size() - 1;
    }

    @Override
    public void load(int id, NBTTagCompound nbt) {
        if (id >= 0 && id < this.properties.size()) {
            this.properties.get(id).readFromNBT(nbt);
        }
    }

    @Override
    public void notifyOfChange(NetPropertyAbstract prop) {
    }

    @Override
    public void sendChangesToNearby() {
        this.requestSync();
    }
}

