/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.asm;

import com.mrdimka.hammercore.asm.HammerCoreCore;
import com.mrdimka.hammercore.asm.ObjectWebUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class HammerCoreTransformer
implements IClassTransformer {
    private String classNameWorld = "ajs";
    private String targetMethodDesc = "(Lco;Lajw;)I";
    private String computeLightValueMethodName = "a";
    private String goalInvokeDesc = "(Latl;Laju;Lco;)I";
    private Printer printer = new Textifier();
    private TraceMethodVisitor mp = new TraceMethodVisitor(this.printer);

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        byte[] cl = this.handleTransform(name, transformedName, basicClass);
        return cl;
    }

    private byte[] handleTransform(String name, String transformedName, byte[] basicClass) {
        if (name.equals(this.classNameWorld)) {
            return this.handleWorldTransform(basicClass, true);
        }
        if (name.equals("net.minecraft.world.World")) {
            this.computeLightValueMethodName = "getRawLight";
            this.goalInvokeDesc = "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)I";
            return this.handleWorldTransform(basicClass, false);
        }
        return basicClass;
    }

    private String insnToString(AbstractInsnNode insn) {
        insn.accept((MethodVisitor)this.mp);
        StringWriter sw = new StringWriter();
        this.printer.print(new PrintWriter(sw));
        this.printer.getText().clear();
        return sw.toString();
    }

    private byte[] handleWorldTransform(byte[] bytes, boolean obf) {
        HammerCoreCore.ASM_LOG.info("Transforming net.minecraft.world.World...", new Object[0]);
        ClassNode classNode = ObjectWebUtils.loadClass(bytes);
        String desc = "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Z)Z";
        if (obf) {
            desc = "(L" + this.classNameWorld + ";Lco;Z)Z";
        }
        InsnList canSnowAtBody = new InsnList();
        canSnowAtBody.add((AbstractInsnNode)new VarInsnNode(25, 0));
        canSnowAtBody.add((AbstractInsnNode)new VarInsnNode(25, 1));
        canSnowAtBody.add((AbstractInsnNode)new VarInsnNode(21, 2));
        canSnowAtBody.add((AbstractInsnNode)new MethodInsnNode(184, "com/pengu/hammercore/asm/SnowfallHooks", "canSnowAtBody", desc));
        canSnowAtBody.add((AbstractInsnNode)new InsnNode(172));
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(this.computeLightValueMethodName) || obf && !m.desc.equals(this.targetMethodDesc)) continue;
            AbstractInsnNode targetNode = null;
            ListIterator iter = m.instructions.iterator();
            boolean found = false;
            int index = 0;
            block1: while (iter.hasNext()) {
                targetNode = (AbstractInsnNode)iter.next();
                if (targetNode.getOpcode() == 58) {
                    VarInsnNode astore = (VarInsnNode)targetNode;
                    while (targetNode.getOpcode() != 54) {
                        if (targetNode instanceof MethodInsnNode && targetNode.getOpcode() != 185) {
                            MethodInsnNode mNode = (MethodInsnNode)targetNode;
                            found = true;
                            iter.remove();
                            targetNode = (AbstractInsnNode)iter.next();
                            break block1;
                        }
                        targetNode = (AbstractInsnNode)iter.next();
                    }
                    break;
                }
                ++index;
            }
            if (!found) break;
            m.instructions.insertBefore(targetNode, (AbstractInsnNode)new MethodInsnNode(184, "com/mrdimka/hammercore/api/dynlight/ProxiedDynlightGetter", "getLightValue", this.goalInvokeDesc, false));
            break;
        }
        return ObjectWebUtils.writeClassToByteArray(classNode);
    }

    private MethodNode getMoonPhase(String name) {
        MethodNode func_72853_d = new MethodNode(327680);
        func_72853_d.desc = "()I";
        func_72853_d.access = 1;
        func_72853_d.exceptions = new ArrayList();
        func_72853_d.name = name;
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "com/pengu/hammercore/asm/WorldHooks", "getMoonPhase", "(L" + this.classNameWorld + ";)I"));
        list.add((AbstractInsnNode)new InsnNode(172));
        func_72853_d.instructions = list;
        return func_72853_d;
    }
}

