/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.bookAPI;

import com.mrdimka.hammercore.bookAPI.BookCategory;
import com.mrdimka.hammercore.bookAPI.BookPage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public class BookEntry {
    protected final List<BookPage> pages = new ArrayList<BookPage>();
    public final BookCategory category;
    public final String entryId;
    public String title;
    protected ItemStack icon;

    public BookEntry(BookCategory category, String id, String title) {
        this.title = title;
        this.entryId = id;
        this.category = category;
        category.entries.add(this);
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public String getTitle() {
        return I18n.func_74838_a((String)this.title);
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isDisabled() {
        return false;
    }

    public int getHoverColor() {
        return this.isDisabled() ? 0xFF0000 : 0xFFFFFF;
    }

    @Nullable
    public BookPage getPageAt(int index) {
        return index < 0 || index >= this.pages.size() ? null : this.pages.get(index);
    }

    public ItemStack getIcon() {
        return this.icon != null ? this.icon : ItemStack.field_190927_a;
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon;
    }
}

