/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.cfg;

import com.mrdimka.hammercore.cfg.IConfigReloadListener;
import com.mrdimka.hammercore.cfg.fields.ModConfigPropertyBool;
import com.mrdimka.hammercore.cfg.fields.ModConfigPropertyFloat;
import com.mrdimka.hammercore.cfg.fields.ModConfigPropertyInt;
import com.mrdimka.hammercore.cfg.fields.ModConfigPropertyString;
import com.mrdimka.hammercore.cfg.fields.ModConfigPropertyStringList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import net.minecraftforge.common.config.Configuration;

public class ConfigHolder {
    public final IConfigReloadListener listener;
    public final Configuration configs;

    public ConfigHolder(IConfigReloadListener listener, Configuration configs) {
        this.listener = listener;
        this.configs = configs;
    }

    public void reload() {
        Field[] fields;
        for (Field f : fields = this.listener.getClass().getDeclaredFields()) {
            try {
                boolean flag;
                Annotation prop;
                f.setAccessible(true);
                Class<?> type = f.getType();
                if (type == String.class) {
                    prop = f.getAnnotation(ModConfigPropertyString.class);
                    boolean bl = flag = prop.allowedValues() == null || prop.allowedValues().length == 0;
                    if (prop != null && flag) {
                        f.set(this.listener, this.configs.getString(prop.name(), prop.category(), prop.defaultValue(), prop.comment()));
                    } else if (prop != null) {
                        f.set(this.listener, this.configs.getString(prop.name(), prop.category(), prop.defaultValue(), prop.comment(), prop.allowedValues()));
                    }
                }
                if (type == String[].class) {
                    prop = f.getAnnotation(ModConfigPropertyStringList.class);
                    boolean bl = flag = prop.allowedValues() == null || prop.allowedValues().length == 0;
                    if (prop != null && flag) {
                        f.set(this.listener, this.configs.getStringList(prop.name(), prop.category(), prop.defaultValue(), prop.comment()));
                    } else if (prop != null) {
                        f.set(this.listener, this.configs.getStringList(prop.name(), prop.category(), prop.defaultValue(), prop.comment(), prop.allowedValues()));
                    }
                }
                if ((type == Integer.TYPE || type == Integer.class) && (prop = f.getAnnotation(ModConfigPropertyInt.class)) != null) {
                    f.set(this.listener, this.configs.getInt(prop.name(), prop.category(), prop.defaultValue(), prop.min(), prop.max(), prop.comment()));
                }
                if ((type == Float.TYPE || type == Float.class) && (prop = f.getAnnotation(ModConfigPropertyFloat.class)) != null) {
                    f.set(this.listener, Float.valueOf(this.configs.getFloat(prop.name(), prop.category(), prop.defaultValue(), prop.min(), prop.max(), prop.comment())));
                }
                if (type != Boolean.TYPE && type != Boolean.class || (prop = f.getAnnotation(ModConfigPropertyBool.class)) == null) continue;
                f.set(this.listener, this.configs.getBoolean(prop.name(), prop.category(), prop.defaultValue(), prop.comment()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.listener.reloadCustom(this.configs);
        if (this.configs.hasChanged()) {
            this.configs.save();
        }
    }
}

