/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.client;

import com.mrdimka.hammercore.api.RequiredDeps;
import com.mrdimka.hammercore.cfg.HammerCoreConfigs;
import com.mrdimka.hammercore.client.GLRenderState;
import com.mrdimka.hammercore.client.UV;
import com.mrdimka.hammercore.client.utils.GLImageManager;
import com.mrdimka.hammercore.client.utils.RenderUtil;
import com.mrdimka.hammercore.common.utils.IOUtils;
import com.mrdimka.hammercore.common.utils.WorldUtil;
import com.mrdimka.hammercore.gui.GuiMissingApis;
import com.mrdimka.hammercore.gui.modbrowser.GuiModBrowserLoading;
import com.mrdimka.hammercore.gui.smooth.GuiBrewingStandSmooth;
import com.mrdimka.hammercore.gui.smooth.GuiFurnaceSmooth;
import com.mrdimka.hammercore.json.JSONArray;
import com.mrdimka.hammercore.json.JSONObject;
import com.mrdimka.hammercore.json.JSONTokener;
import com.mrdimka.hammercore.math.ExpressionEvaluator;
import com.mrdimka.hammercore.math.MathHelper;
import com.mrdimka.hammercore.math.functions.ExpressionFunction;
import com.mrdimka.hammercore.tile.TileSyncable;
import com.pengu.hammercore.utils.IndexedMap;
import java.awt.image.BufferedImage;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderGui {
    private static final UV hammer = new UV(new ResourceLocation("hammercore", "textures/hammer.png"), 0.0, 0.0, 256.0, 256.0);
    private static final ResourceLocation main_menu_widgets = new ResourceLocation("hammercore", "textures/gui/main_menu_widgets.png");
    private static final SpecialUser user = new SpecialUser();
    private double modListHoverTip = 0.0;
    private boolean renderF3;
    private final IndexedMap<String, Object> f3Right = new IndexedMap();

    @SubscribeEvent
    public void guiRender(GuiScreenEvent.DrawScreenEvent.Post e) {
        GuiScreen gui = e.getGui();
        if (gui instanceof GuiMainMenu) {
            if (HammerCoreConfigs.client_modBrowser) {
                int mouseX = e.getMouseX();
                int mouseY = e.getMouseY();
                int xOff = gui.field_146294_l / 2 - 15;
                boolean isHovered = mouseX >= xOff && mouseY >= 0 && mouseX < xOff + 30 && mouseY < 3;
                this.modListHoverTip = (isHovered |= mouseX >= xOff + 3 && mouseY >= 0 && mouseX < xOff + 27 && (double)mouseY < this.modListHoverTip + 9.0) ? MathHelper.clip(this.modListHoverTip + 0.8, 0.0, 12.0) : MathHelper.clip(this.modListHoverTip - 0.8, 0.0, 12.0);
                gui.field_146297_k.func_110434_K().func_110577_a(main_menu_widgets);
                GL11.glPushMatrix();
                GL11.glTranslated((double)xOff, (double)0.0, (double)0.0);
                GLRenderState.BLEND.captureState();
                GLRenderState.BLEND.on();
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
                RenderUtil.drawTexturedModalRect(0.0, 0.0, 0.0, 0.0, 30.0, 4.0);
                RenderUtil.drawTexturedModalRect(0.0, 4.0, 0.0, 4.0, 30.0, this.modListHoverTip);
                RenderUtil.drawTexturedModalRect(0.0, 4.0 + this.modListHoverTip, 0.0, 16.0, 30.0, 5.0);
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)(this.modListHoverTip / 12.0));
                RenderUtil.drawTexturedModalRect(0.0, 0.0, 30.0, 0.0, 30.0, 4.0);
                RenderUtil.drawTexturedModalRect(0.0, 4.0, 30.0, 4.0, 30.0, this.modListHoverTip);
                RenderUtil.drawTexturedModalRect(0.0, 4.0 + this.modListHoverTip, 30.0, 16.0, 30.0, 5.0);
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
                float f = 1.0f - net.minecraft.util.math.MathHelper.func_76135_e((float)(net.minecraft.util.math.MathHelper.func_76126_a((float)((float)((Minecraft.func_71386_F() + 47647L) % 10000L) / 10000.0f * ((float)Math.PI * 2))) * 0.1f));
                GL11.glPushMatrix();
                GL11.glTranslated((double)(14.0f - f * 8.0f + 8.0f), (double)(this.modListHoverTip - 3.0 - (double)(f * 8.0f) + 8.0), (double)0.0);
                GL11.glRotated((double)((12.0 - this.modListHoverTip) / 12.0 * -90.0), (double)0.0, (double)0.0, (double)1.0);
                GL11.glTranslated((double)-8.0, (double)-8.0, (double)0.0);
                hammer.render(0.0, 0.0, 16.0f * f, 16.0f * f);
                GL11.glPopMatrix();
                GLRenderState.BLEND.reset();
                GL11.glPopMatrix();
            }
            RenderGui.user.draw();
        }
    }

    @SubscribeEvent
    public void mouseClick(GuiScreenEvent.MouseInputEvent.Pre evt) {
        GuiScreen gui;
        int mouseX = Mouse.getEventX() * evt.getGui().field_146294_l / evt.getGui().field_146297_k.field_71443_c;
        int mouseY = evt.getGui().field_146295_m - Mouse.getEventY() * evt.getGui().field_146295_m / evt.getGui().field_146297_k.field_71440_d - 1;
        int eventButton = Mouse.getEventButton();
        if (Mouse.getEventButtonState() && (gui = evt.getGui()) instanceof GuiMainMenu) {
            int xOff = evt.getGui().field_146294_l / 2 - 15;
            boolean isHovered = mouseX >= xOff && mouseY >= 0 && mouseX < xOff + 30 && mouseY < 3;
            if ((isHovered |= mouseX >= xOff + 3 && mouseY >= 0 && mouseX < xOff + 27 && (double)mouseY < this.modListHoverTip + 9.0) && eventButton == 0 && HammerCoreConfigs.client_modBrowser) {
                this.modListHoverTip = 0.0;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                GuiModBrowserLoading gui0 = new GuiModBrowserLoading();
                gui.field_146297_k.func_147108_a((GuiScreen)gui0);
                gui0.panoramaTimer = ((GuiMainMenu)gui).field_73979_m;
            }
        }
    }

    @SubscribeEvent
    public void addF3Info(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.DEBUG) {
            this.renderF3 = true;
        }
    }

    @SubscribeEvent
    public void addF3Info(RenderGameOverlayEvent.Text f3) {
        RayTraceResult omon = Minecraft.func_71410_x().field_71476_x;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (this.renderF3) {
            TileSyncable ts;
            ArrayList tip = f3.getRight();
            if (world != null && omon != null && omon.field_72313_a == RayTraceResult.Type.BLOCK && (ts = WorldUtil.cast(world.func_175625_s(omon.func_178782_a()), TileSyncable.class)) != null) {
                this.f3Right.clear();
                ts.addProperties(this.f3Right, omon);
                List<String> keys = this.f3Right.getKeys();
                for (int i = 0; i < keys.size(); ++i) {
                    String key = keys.get(i);
                    Object val = this.f3Right.get(key);
                    String str = "";
                    str = val instanceof Boolean ? (val == Boolean.TRUE ? TextFormatting.GREEN : TextFormatting.RED) + val + "" + TextFormatting.RESET : val + "";
                    tip.add(key.toLowerCase() + ": " + str);
                }
            }
            this.renderF3 = false;
        }
    }

    @SubscribeEvent
    public void openGui(GuiOpenEvent evt) {
        Object gui;
        GuiScreen fgui = gui = evt.getGui();
        if (gui instanceof GuiMainMenu) {
            new Thread(() -> {
                RenderGui.user.download();
                RenderGui.user.reload(true);
            }).start();
        }
        if (gui instanceof GuiMainMenu && !RequiredDeps.allDepsResolved()) {
            gui = new GuiMissingApis();
        }
        if (HammerCoreConfigs.client_smoothVanillaGuis) {
            GuiFurnace g;
            if (gui instanceof GuiFurnace) {
                g = (GuiFurnace)gui;
                gui = new GuiFurnaceSmooth(g.field_175383_v, g.field_147086_v);
            }
            if (gui instanceof GuiBrewingStand) {
                g = (GuiBrewingStand)gui;
                gui = new GuiBrewingStandSmooth(g.field_175384_v, g.field_147013_v);
            }
        }
        if (fgui != gui) {
            evt.setGui(gui);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static final class IMG {
        private BufferedImage img;
        private String x;
        private String y;
        private String width;
        private String height;

        private IMG() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static final class SpecialUser {
        private final int glImage = GL11.glGenTextures();
        private final List<IMG> images = new ArrayList<IMG>();
        private long lastDownload = 0L;
        private final SecureRandom rand = new SecureRandom();
        private double x;
        private double y;
        private double width;
        private double height;
        private IMG currImg;

        private SpecialUser() {
        }

        private void download() {
            try {
                int i;
                JSONArray arr = (JSONArray)new JSONTokener(new String(IOUtils.downloadData("http://pastebin.com/raw/JKDpcHL1"))).nextValue();
                for (i = 0; i < arr.length(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    if (!obj.optBoolean("enabled", false) || !obj.getString("username").equals(Minecraft.func_71410_x().func_110432_I().func_111285_a())) continue;
                    arr = obj.getJSONArray("images");
                    break;
                }
                this.images.clear();
                for (i = 0; i < arr.length(); ++i) {
                    JSONObject o = arr.getJSONObject(i);
                    IMG img = new IMG();
                    img.img = IOUtils.downloadPicture(o.getString("url"));
                    JSONObject signature = o.getJSONObject("signature");
                    img.x = signature.getString("x");
                    img.y = signature.getString("y");
                    img.width = signature.getString("width");
                    img.height = signature.getString("height");
                    this.images.add(img);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private boolean reload(boolean launchThread) {
            try {
                if (this.images.isEmpty()) {
                    this.currImg = null;
                    this.height = 0.0;
                    this.width = 0.0;
                    this.y = 0.0;
                    this.x = 0.0;
                    return true;
                }
                IMG i = this.currImg = this.images.get(this.rand.nextInt(this.images.size()));
                String sx = i.x;
                String sy = i.y;
                String sw = i.width;
                String sh = i.height;
                sx = this.format(sx);
                sy = this.format(sy);
                sw = this.format(sw);
                sh = this.format(sh);
                this.x = ExpressionEvaluator.evaluateDouble(sx, new ExpressionFunction[0]);
                this.y = ExpressionEvaluator.evaluateDouble(sy, new ExpressionFunction[0]);
                this.width = ExpressionEvaluator.evaluateDouble(sw, new ExpressionFunction[0]);
                this.height = ExpressionEvaluator.evaluateDouble(sh, new ExpressionFunction[0]);
                return true;
            }
            catch (Throwable err) {
                if (launchThread) {
                    new Thread(() -> {
                        int i = 0;
                        while (++i < 5 && !this.reload(false)) {
                        }
                    }).start();
                }
                return false;
            }
        }

        private String format(String s) {
            if (s == null) {
                return "0";
            }
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution sr = new ScaledResolution(mc);
            GuiScreen gs = mc.field_71462_r;
            double displacex = sr.func_78327_c() / (double)sr.func_78326_a();
            double displacey = sr.func_78324_d() / (double)sr.func_78328_b();
            s = s.replaceAll("mc-width", mc.field_71443_c + "");
            s = s.replaceAll("mc-height", mc.field_71440_d + "");
            return s;
        }

        private void draw() {
            if (this.currImg == null || this.currImg.img == null) {
                return;
            }
            if (System.currentTimeMillis() - this.lastDownload > 10000L) {
                GLImageManager.loadTexture(this.currImg.img, this.glImage, false);
                this.lastDownload = System.currentTimeMillis();
            }
            GlStateManager.func_179144_i((int)this.glImage);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glTranslated((double)this.x, (double)this.y, (double)0.0);
            GL11.glScaled((double)this.width, (double)this.height, (double)1.0);
            GL11.glScaled((double)(1.0 / (double)this.currImg.img.getWidth()), (double)(1.0 / (double)this.currImg.img.getHeight()), (double)1.0);
            RenderUtil.drawTexturedModalRect(0.0, 0.0, 0.0, 0.0, 256.0, 256.0);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }
}

