/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.client.renderer.tile;

import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.api.multipart.IMultipartRender;
import com.mrdimka.hammercore.api.multipart.MultipartRenderingRegistry;
import com.mrdimka.hammercore.api.multipart.MultipartSignature;
import com.mrdimka.hammercore.common.blocks.multipart.BlockMultipart;
import com.mrdimka.hammercore.common.blocks.multipart.TileMultipart;
import com.mrdimka.hammercore.init.ModBlocks;
import com.mrdimka.hammercore.raytracer.RayTracer;
import com.mrdimka.hammercore.vec.Cuboid6;
import com.pengu.hammercore.client.DestroyStageTexture;
import com.pengu.hammercore.client.render.tesr.TESR;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class TileRenderMultipart
extends TESR<TileMultipart> {
    @Override
    public void renderTileEntityAt(TileMultipart te, double x, double y, double z, float partialTicks, ResourceLocation destroyStage) {
        try {
            List<MultipartSignature> mps = te.signatures();
            if (mps == null) {
                return;
            }
            BlockMultipart bmp = (BlockMultipart)ModBlocks.MULTIPART;
            World w = te.func_145831_w();
            EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
            Cuboid6 cbd = bmp.getCuboidFromRTR(te.func_145831_w(), bmp.func_180636_a(w.func_180495_p(te.func_174877_v()), w, te.func_174877_v(), RayTracer.getCorrectedHeadVec((EntityPlayer)p), RayTracer.getEndVec((EntityPlayer)p)));
            AxisAlignedBB aabb = cbd != null ? cbd.aabb() : null;
            for (MultipartSignature s : mps) {
                IMultipartRender<MultipartSignature> render = MultipartRenderingRegistry.getRender(s);
                GL11.glPushMatrix();
                if (render != null) {
                    render.renderMultipartAt(s, x, y, z, partialTicks, aabb != null && s.getBoundingBox() != null && aabb.equals((Object)s.getBoundingBox()) ? destroyStage : null);
                }
                GL11.glPopMatrix();
            }
        }
        catch (Throwable err) {
            HammerCore.LOG.error("Failed to render multipart at " + te.func_174877_v() + ": " + err, new Object[0]);
        }
    }

    @Override
    public boolean canRenderFromNbt() {
        return false;
    }

    @Deprecated
    public static class DestroyStage {
        @Deprecated
        public static ResourceLocation getByProgress(float progress) {
            return DestroyStageTexture.getByProgress(progress);
        }
    }
}

