/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.command;

import com.mrdimka.hammercore.structure.StructureAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandBuildStructure
extends CommandBase {
    public String func_71517_b() {
        return "hc_buildstr";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Use /hc_buildstr <structure, use TAB> OR /hc_buildstr <x> <y> <z> <structure, use TAB>";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1 && args.length != 4) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Illegal argument count, required: 1 or 4"));
            return;
        }
        BlockPos startPos = null;
        if (args.length == 1) {
            startPos = sender.func_180425_c();
        }
        if (args.length == 4) {
            startPos = CommandBuildStructure.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)false);
        }
        if (!StructureAPI.GetAllStructures().contains(args[0])) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Illegal value (" + args[0] + ")"));
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Building " + args[0] + "..."));
        long start = System.currentTimeMillis();
        try {
            StructureAPI.Import(sender.func_130014_f_(), startPos, StructureAPI.ParseBuiltin(new ResourceLocation(args[0])));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + args[0] + " built in " + (System.currentTimeMillis() - start) + " ms."));
        }
        catch (IOException e) {
            e.printStackTrace();
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + args[0] + " wasn't built: " + e.getMessage()));
            return;
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        return args.length == 1 ? new ArrayList(StructureAPI.GetAllStructures()) : (args.length > 1 && args.length < 5 ? CommandBuildStructure.func_175771_a((String[])args, (int)1, (BlockPos)targetPos) : new ArrayList());
    }
}

