/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.blocks.tesseract;

import com.mrdimka.hammercore.api.ITileBlock;
import com.mrdimka.hammercore.common.blocks.tesseract.TileTesseract;
import com.mrdimka.hammercore.common.utils.WorldUtil;
import com.mrdimka.hammercore.gui.GuiManager;
import com.mrdimka.hammercore.tile.TileSyncable;
import com.pengu.hammercore.common.IWrenchable;
import com.pengu.hammercore.utils.WorldLocation;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class BlockTesseract
extends Block
implements ITileEntityProvider,
ITileBlock<TileTesseract>,
IWrenchable {
    public static final PropertyBool active = PropertyBool.func_177716_a((String)"active");

    public BlockTesseract() {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(15.0f);
        this.func_149752_b(2000.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149663_c("tesseract");
    }

    public void func_190948_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_150297_b("Private", 1)) {
                boolean b = stack.func_77978_p().func_74767_n("Private");
                tooltip.add("Private: " + (b ? TextFormatting.GREEN : TextFormatting.RED) + b + TextFormatting.RESET);
            }
            if (stack.func_77978_p().func_150297_b("Frequency", 8)) {
                String s = stack.func_77978_p().func_74779_i("Frequency");
                tooltip.add("Frequency: " + s);
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        WorldLocation loc = new WorldLocation(worldIn, pos);
        TileTesseract tess = loc.getTileOfType(TileTesseract.class);
        if (tess == null) {
            tess = new TileTesseract();
            loc.setTile(tess);
        }
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt.func_150297_b("Frequency", 8)) {
                tess.setFrequency(nbt.func_74779_i("Frequency"));
            }
            if (nbt.func_150297_b("Private", 1)) {
                tess.isPrivate.set(nbt.func_74767_n("Private"));
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileSyncable tile = WorldUtil.cast(worldIn.func_175625_s(pos), TileSyncable.class);
        GuiManager.openGui(playerIn, tile);
        return tile != null && tile.hasGui();
    }

    @Override
    public Class<TileTesseract> getTileClass() {
        return TileTesseract.class;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileTesseract();
    }

    public boolean func_189872_a(IBlockState state, Entity entityIn) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)active) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(meta != 0));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{active});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public boolean onWrenchUsed(WorldLocation loc, EntityPlayer player, EnumHand hand) {
        TileTesseract tess = loc.getTileOfType(TileTesseract.class);
        if (player.func_70093_af() && tess != null) {
            loc.setState(Blocks.field_150350_a.func_176223_P());
            ItemStack stack = new ItemStack((Block)this);
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74778_a("Frequency", tess.frequency.get());
            stack.func_77978_p().func_74757_a("Private", tess.isPrivate.get().booleanValue());
            WorldUtil.spawnItemStack(loc, stack);
        }
        return true;
    }
}

