/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.blocks.tesseract;

import com.mrdimka.hammercore.common.blocks.tesseract.BlockTesseract;
import com.mrdimka.hammercore.common.blocks.tesseract.TransferMode;
import com.mrdimka.hammercore.common.capabilities.CapabilityEJ;
import com.mrdimka.hammercore.gui.GuiTesseract;
import com.mrdimka.hammercore.gui.container.ContainerEmpty;
import com.mrdimka.hammercore.init.ModBlocks;
import com.mrdimka.hammercore.init.ModItems;
import com.mrdimka.hammercore.tile.IMalfunctionable;
import com.mrdimka.hammercore.tile.ITileDroppable;
import com.mrdimka.hammercore.tile.TileSyncableTickable;
import com.pengu.hammercore.net.utils.IPropertyChangeHandler;
import com.pengu.hammercore.net.utils.NetPropertyBool;
import com.pengu.hammercore.net.utils.NetPropertyNumber;
import com.pengu.hammercore.net.utils.NetPropertyString;
import com.pengu.hammercore.net.utils.NetPropertyUUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileTesseract
extends TileSyncableTickable
implements ITileDroppable,
IMalfunctionable {
    public static final Map<String, List<TileTesseract>> TESSERACTS = new HashMap<String, List<TileTesseract>>();
    public final NetPropertyString frequency = new NetPropertyString((IPropertyChangeHandler)this, "");
    public final NetPropertyUUID owner = new NetPropertyUUID(this);
    public final NetPropertyBool isPrivate = new NetPropertyBool(this);
    public final NetPropertyNumber<Integer> ioPage = new NetPropertyNumber<Integer>(this, 0);
    private int malfunctionTicks = 0;
    public final Map<Capability, TransferMode> MODES = new HashMap<Capability, TransferMode>();
    private static final List<Capability> ALLOWED_CAPABILITIES = new ArrayList<Capability>();
    private static final List<String> ALLOWED_CAPABILITY_NAMES = new ArrayList<String>();
    private static final List<ItemStack> ALLOWED_CAPABILITY_ICONS = new ArrayList<ItemStack>();

    public static void registerTesseractCapability(Capability cap, String id, ItemStack icon) {
        ALLOWED_CAPABILITIES.add(cap);
        ALLOWED_CAPABILITY_NAMES.add(id);
        ALLOWED_CAPABILITY_ICONS.add(icon);
    }

    @Override
    public void addProperties(Map<String, Object> properties, RayTraceResult trace) {
        properties.put("private", this.isPrivate.get());
        String frequency = this.frequency.get();
        if (frequency != null && !frequency.isEmpty()) {
            for (int i = 0; i < ALLOWED_CAPABILITIES.size(); ++i) {
                Capability cap = ALLOWED_CAPABILITIES.get(i);
                properties.put(TileTesseract.getCapName(cap), this.getMode(cap) == TransferMode.ALLOW);
            }
        }
        properties.put((frequency != null && !frequency.isEmpty() ? TextFormatting.GREEN : TextFormatting.RED) + "frequency" + TextFormatting.RESET, frequency != null && !frequency.isEmpty() ? frequency : TextFormatting.RED + "?" + TextFormatting.RESET);
    }

    public static List<Capability> getAllowedCapabilities() {
        return ALLOWED_CAPABILITIES;
    }

    public static String getCapNameRaw(Capability cap) {
        int index = ALLOWED_CAPABILITIES.indexOf(cap);
        if (index == -1) {
            return null;
        }
        return ALLOWED_CAPABILITY_NAMES.get(index);
    }

    public static ItemStack getCapIcon(Capability cap) {
        int index = ALLOWED_CAPABILITIES.indexOf(cap);
        if (index == -1) {
            return null;
        }
        return ALLOWED_CAPABILITY_ICONS.get(index).func_77946_l();
    }

    public static String getCapName(Capability cap) {
        int index = ALLOWED_CAPABILITIES.indexOf(cap);
        if (index == -1) {
            return null;
        }
        return I18n.func_74838_a((String)("capability." + ALLOWED_CAPABILITY_NAMES.get(index) + ".name"));
    }

    @Override
    public void onPlacedBy(EntityPlayer player, EnumHand hand) {
        this.owner.set(player.func_146103_bH().getId());
    }

    @Override
    public void tick() {
        IBlockState state;
        if (this.malfunctionTicks > 0) {
            --this.malfunctionTicks;
        }
        if (this.frequency.get() != null && !this.frequency.get().isEmpty() && this.malfunctionTicks <= 0 && this.atTickRate(20)) {
            TileTesseract.addTesseract(this);
        }
        if (this.frequency.get() != null && !this.frequency.get().isEmpty() && this.malfunctionTicks > 0 && this.atTickRate(20)) {
            TileTesseract.removeTesseract(this);
        }
        if (this.atTickRate(20) && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == ModBlocks.TESSERACT) {
            boolean shouldBeActive;
            boolean isActive = (Boolean)state.func_177229_b((IProperty)BlockTesseract.active);
            boolean bl = shouldBeActive = this.frequency.get() != null && !this.frequency.get().isEmpty() && this.malfunctionTicks <= 0;
            if (isActive != shouldBeActive) {
                state = state.func_177226_a((IProperty)BlockTesseract.active, (Comparable)Boolean.valueOf(shouldBeActive));
                this.field_145850_b.func_180501_a(this.field_174879_c, state, 1);
                this.func_145829_t();
                this.field_145850_b.func_175690_a(this.field_174879_c, (TileEntity)this);
            }
        }
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiTesseract(this);
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerEmpty();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Capability c : this.MODES.keySet()) {
            TransferMode mode = this.getMode(c);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Name", TileTesseract.getCapNameRaw(c));
            tag.func_74757_a("Active", mode.active());
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Caps", (NBTBase)list);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Caps", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int index = ALLOWED_CAPABILITY_NAMES.indexOf(tag.func_74779_i("Name"));
            if (index == -1) continue;
            this.setMode(ALLOWED_CAPABILITIES.get(index), tag.func_74767_n("Active") ? TransferMode.ALLOW : TransferMode.DECLINE);
        }
    }

    public void setFrequency(String freq) {
        this.frequency.set(freq);
        if (freq != null && !freq.isEmpty()) {
            TileTesseract.addTesseract(this);
        } else {
            TileTesseract.removeTesseract(this);
        }
    }

    public boolean isValid() {
        return this.field_145850_b != null && this.field_174879_c != null && this.field_145850_b.func_175667_e(this.field_174879_c) && this.field_145850_b.func_175625_s(this.field_174879_c) == this && this.frequency.get() != null && !this.frequency.get().isEmpty();
    }

    public static void revalidateTesseracts() {
        Iterator<List<TileTesseract>> tiles = TESSERACTS.values().iterator();
        while (tiles.hasNext()) {
            List<TileTesseract> tess = tiles.next();
            if (tess == null || tess.isEmpty()) continue;
            for (int i = 0; i < tess.size(); ++i) {
                TileTesseract tess2 = tess.get(i);
                if (tess2 != null && tess2.isValid()) continue;
                tess.remove(i);
            }
            if (!tess.isEmpty()) continue;
            tiles.remove();
        }
    }

    public final String getMapName() {
        return (this.isPrivate.get() != false ? this.owner.get() + "" : "public") + ":" + this.frequency.get();
    }

    public static void addTesseract(TileTesseract tesseract) {
        TileTesseract.removeTesseract(tesseract);
        if (tesseract == null || tesseract.frequency.get() == null || tesseract.frequency.get().isEmpty()) {
            return;
        }
        List<TileTesseract> tiles = TESSERACTS.get(tesseract.getMapName());
        if (tiles == null) {
            tiles = new ArrayList<TileTesseract>();
            TESSERACTS.put(tesseract.getMapName(), tiles);
        }
        if (!tiles.contains(tesseract)) {
            tiles.add(tesseract);
        }
    }

    public static void removeTesseract(TileTesseract tesseract) {
        Iterator<List<TileTesseract>> tiles = TESSERACTS.values().iterator();
        while (tiles.hasNext()) {
            List<TileTesseract> tess = tiles.next();
            if (tess == null || tess.isEmpty()) {
                tiles.remove();
                continue;
            }
            for (int i = 0; i < tess.size(); ++i) {
                TileTesseract tess2 = tess.get(i);
                if (tess2 != tesseract) continue;
                tess.remove(i);
            }
            if (!tess.isEmpty()) continue;
            tiles.remove();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        TileTesseract.removeTesseract(this);
    }

    @Override
    public void createDrop(EntityPlayer player, World world, BlockPos pos) {
        TileTesseract.removeTesseract(this);
    }

    public <T> T getSidedCapability(Capability<T> cap, EnumFacing facing) {
        BlockPos npos;
        if (facing == null) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                T cap0 = this.getSidedCapability(cap, face);
                if (cap0 == null) continue;
                return cap0;
            }
            return null;
        }
        if (this.isValid() && this.field_145850_b.func_175667_e(npos = this.field_174879_c.func_177972_a(facing.func_176734_d())) && this.field_145850_b.func_175625_s(npos) != null) {
            TileEntity tile = this.field_145850_b.func_175625_s(npos);
            if (tile instanceof TileTesseract) {
                return null;
            }
            Object c = tile.getCapability(cap, facing);
            if (c != null) {
                return (T)c;
            }
        }
        return null;
    }

    public <T> boolean hasSidedCapability(Capability<T> cap, EnumFacing facing) {
        BlockPos npos;
        if (facing == null) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                if (!this.hasSidedCapability(cap, face)) continue;
                return true;
            }
            return false;
        }
        if (this.isValid() && this.field_145850_b.func_175667_e(npos = this.field_174879_c.func_177972_a(facing.func_176734_d())) && this.field_145850_b.func_175625_s(npos) != null) {
            TileEntity tile = this.field_145850_b.func_175625_s(npos);
            if (tile instanceof TileTesseract) {
                return false;
            }
            if (tile.hasCapability(cap, facing)) {
                return true;
            }
        }
        return false;
    }

    public void setMode(Capability capability, TransferMode mode) {
        if (!ALLOWED_CAPABILITIES.contains(capability)) {
            return;
        }
        this.MODES.put(capability, mode);
    }

    public TransferMode getMode(Capability capability) {
        if (!ALLOWED_CAPABILITIES.contains(capability)) {
            return TransferMode.DECLINE;
        }
        if (this.MODES.get(capability) == null) {
            this.MODES.put(capability, TransferMode.ALLOW);
        }
        return this.MODES.get(capability);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (!this.getMode(capability).active()) {
            return null;
        }
        if (this.isValid()) {
            List<TileTesseract> tile = TESSERACTS.get(this.getMapName());
            if (tile == null) {
                tile = new ArrayList<TileTesseract>();
                TESSERACTS.put(this.getMapName(), tile);
                tile.add(this);
            }
            for (int i = 0; i < tile.size(); ++i) {
                TileTesseract tess = tile.get(i);
                if (tess == this || !tess.getMode(capability).active()) continue;
                T cap = tess.getSidedCapability(capability, null);
                if (tess == null || cap == null) continue;
                return cap;
            }
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    @Override
    public void causeGeneralMalfunction() {
        this.malfunctionTicks += 80 + this.field_145850_b.field_73012_v.nextInt(80);
    }

    static {
        TileTesseract.registerTesseractCapability(CapabilityEnergy.ENERGY, "fe", new ItemStack(ModItems.battery));
        TileTesseract.registerTesseractCapability(CapabilityEJ.ENERGY, "ej", new ItemStack(ModItems.battery));
        TileTesseract.registerTesseractCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, "fluid", new ItemStack(Items.field_151133_ar));
        TileTesseract.registerTesseractCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, "items", new ItemStack(Items.field_151055_y));
    }
}

