/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.utils;

import java.text.DecimalFormat;

public class FileSizeMetric {
    public static final float KiB = 1024.0f;
    public static final float MeB = 1048576.0f;
    public static final float GiB = 1.0737418E9f;
    public static final float TeB = 1.0995116E12f;
    public static final DecimalFormat format = new DecimalFormat("#,##0.00");
    public static final DecimalFormat formati = new DecimalFormat("#,###");

    public static String toMaxSize(long bytes) {
        if ((float)bytes < 1024.0f) {
            return formati.format(bytes) + "B";
        }
        if ((float)bytes < 1048576.0f) {
            return format.format((float)bytes / 1024.0f) + "KiB";
        }
        if ((float)bytes < 1.0737418E9f) {
            return format.format((float)bytes / 1048576.0f) + "MiB";
        }
        if ((float)bytes < 1.0995116E12f) {
            return format.format((float)bytes / 1.0737418E9f) + "GiB";
        }
        return (float)bytes / 1.0737418E9f + "TeB";
    }
}

