/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.utils;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.function.Supplier;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.imageio.ImageIO;

public class IOUtils {
    public static int heapLimit = 4096;
    public static final byte[] ZERO_ARRAY = new byte[0];
    private static final ThreadLocal<byte[]> buf = ThreadLocal.withInitial(new Supplier<byte[]>(){

        @Override
        public byte[] get() {
            return new byte[heapLimit];
        }
    });

    public static BufferedImage downloadPicture(String url) {
        try {
            return ImageIO.read(new URL(url));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static byte[] downloadData(String url) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.downloadAndWriteData(url, baos);
            byte[] buf = baos.toByteArray();
            return buf;
        }
        catch (Throwable throwable) {
            return ZERO_ARRAY;
        }
    }

    public static void downloadAndWriteData(String url, OutputStream o) {
        try {
            URL u = new URL(url);
            InputStream input = u.openStream();
            IOUtils.pipeData(input, o);
            input.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void pipeData(InputStream from, OutputStream to) {
        try {
            byte[] buf = IOUtils.buf.get();
            int read = 0;
            while ((read = from.read(buf)) > 0) {
                to.write(buf, 0, read);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static byte[] pipeOut(InputStream from) {
        ByteArrayOutputStream to = new ByteArrayOutputStream();
        IOUtils.pipeData(from, to);
        return to.toByteArray();
    }

    public static byte[] pipeOutAvaliable(InputStream from) {
        try {
            byte[] buf = new byte[from.available()];
            from.read(buf);
            return buf;
        }
        catch (Throwable throwable) {
            return ZERO_ARRAY;
        }
    }

    public static byte[] deflaterCompress(byte[] data) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DeflaterOutputStream o = new DeflaterOutputStream((OutputStream)baos, new Deflater(9));
            o.write(data);
            o.close();
            return baos.toByteArray();
        }
        catch (Throwable throwable) {
            return ZERO_ARRAY;
        }
    }

    public static byte[] deflaterUncompress(byte[] data) {
        try {
            InflaterInputStream i = new InflaterInputStream(new ByteArrayInputStream(data), new Inflater());
            data = IOUtils.pipeOut(i);
            i.close();
            return data;
        }
        catch (Throwable throwable) {
            return ZERO_ARRAY;
        }
    }

    public static String followRedirects(String url) throws IOException {
        String u;
        URL obj = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
        conn.setReadTimeout(5000);
        conn.addRequestProperty("Accept-Language", "en-US,en;q=0.8");
        conn.addRequestProperty("User-Agent", "Mozilla");
        conn.addRequestProperty("Referer", "google.com");
        boolean redirect = false;
        int status = conn.getResponseCode();
        if (status != 200 && (status == 302 || status == 301 || status == 303)) {
            redirect = true;
        }
        if (redirect) {
            String newUrl = conn.getHeaderField("Location");
            String cookies = conn.getHeaderField("Set-Cookie");
            conn = (HttpURLConnection)new URL(newUrl).openConnection();
            conn.setRequestProperty("Cookie", cookies);
            conn.addRequestProperty("Accept-Language", "en-US,en;q=0.8");
            conn.addRequestProperty("User-Agent", "Mozilla");
            conn.addRequestProperty("Referer", "google.com");
        }
        return (u = conn.getHeaderField("Location")) != null ? u : url;
    }
}

