/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.utils;

import com.mrdimka.hammercore.common.InterItemStack;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemInsertionUtil {
    public static boolean insertVanilla(TileEntity exportFromTE, IInventory exportFrom, EnumFacing facing) {
        TileEntity tileEntity = exportFromTE.func_145831_w().func_175625_s(exportFromTE.func_174877_v().func_177972_a(facing));
        if (tileEntity == null) {
            return false;
        }
        if (!tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
            return false;
        }
        for (EnumFacing f : EnumFacing.field_82609_l) {
            IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f);
            for (int i = 0; i < exportFrom.func_70302_i_(); ++i) {
                ItemStack stackInSlot = exportFrom.func_70301_a(i);
                if (stackInSlot == null) continue;
                ItemStack insert = stackInSlot.func_77946_l();
                InterItemStack.setStackSize(insert, 1);
                ItemStack newStack = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)insert, (boolean)true);
                if (newStack != null && InterItemStack.getStackSize(newStack) != 0) continue;
                ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)exportFrom.func_70298_a(i, 1), (boolean)false);
                exportFromTE.func_70296_d();
                return true;
            }
        }
        return true;
    }

    public static boolean transferItemsOutFinal(TileEntity exportFromTE, IInventory exportFrom, EnumFacing facing) {
        IInventory iinventory;
        if (ItemInsertionUtil.insertVanilla(exportFromTE, exportFrom, facing)) {
            return true;
        }
        IInventory iInventory = iinventory = exportFromTE.func_145831_w().func_175625_s(exportFromTE.func_174877_v().func_177972_a(facing)) instanceof IInventory ? (IInventory)exportFromTE.func_145831_w().func_175625_s(exportFromTE.func_174877_v().func_177972_a(facing)) : null;
        if (iinventory == null) {
            return false;
        }
        if (ItemInsertionUtil.isInventoryFull(iinventory, facing)) {
            return false;
        }
        for (EnumFacing f : EnumFacing.field_82609_l) {
            for (int i = 0; i < exportFrom.func_70302_i_(); ++i) {
                if (exportFrom.func_70301_a(i) == null) continue;
                ItemStack itemstack = exportFrom.func_70301_a(i).func_77946_l();
                ItemStack itemstack1 = ItemInsertionUtil.putStackInInventoryAllSlots(iinventory, exportFrom.func_70298_a(i, 1), f);
                if (itemstack1 == null || InterItemStack.getStackSize(itemstack1) == 0) {
                    iinventory.func_70296_d();
                    return true;
                }
                exportFrom.func_70299_a(i, itemstack);
            }
        }
        return false;
    }

    public static boolean isEmpty(IInventory inv) {
        for (int i$ = 0; i$ < inv.func_70302_i_(); ++i$) {
            ItemStack itemstack = inv.func_70301_a(i$);
            if (itemstack == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isFull(IInventory inv) {
        for (int i$ = 0; i$ < inv.func_70302_i_(); ++i$) {
            ItemStack itemstack = inv.func_70301_a(i$);
            if (itemstack != null && InterItemStack.getStackSize(itemstack) == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public static boolean isInventoryFull(IInventory inv, EnumFacing facing) {
        if (inv instanceof ISidedInventory) {
            ISidedInventory i = (ISidedInventory)inv;
            int[] j = i.func_180463_a(facing);
            for (int itemstack = 0; itemstack < j.length; ++itemstack) {
                ItemStack itemstack1 = i.func_70301_a(j[itemstack]);
                if (itemstack1 != null && InterItemStack.getStackSize(itemstack1) == itemstack1.func_77976_d()) continue;
                return false;
            }
        } else {
            int var7 = inv.func_70302_i_();
            for (int var8 = 0; var8 < var7; ++var8) {
                ItemStack var9 = inv.func_70301_a(var8);
                if (var9 != null && InterItemStack.getStackSize(var9) == var9.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isInventoryEmpty(IInventory inv, EnumFacing facing) {
        if (inv instanceof ISidedInventory) {
            ISidedInventory j = (ISidedInventory)inv;
            int[] k = j.func_180463_a(facing);
            for (int i = 0; i < k.length; ++i) {
                if (j.func_70301_a(k[i]) == null) continue;
                return false;
            }
        } else {
            int var5 = inv.func_70302_i_();
            for (int var6 = 0; var6 < var5; ++var6) {
                if (inv.func_70301_a(var6) == null) continue;
                return false;
            }
        }
        return true;
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory inv, ItemStack stack, @Nullable EnumFacing face) {
        if (inv instanceof ISidedInventory && face != null) {
            ISidedInventory var6 = (ISidedInventory)inv;
            int[] var7 = var6.func_180463_a(face);
            for (int k = 0; k < var7.length && stack != null && InterItemStack.getStackSize(stack) > 0; ++k) {
                stack = ItemInsertionUtil.insertStack(inv, stack, var7[k], face);
            }
        } else {
            int i = inv.func_70302_i_();
            for (int j = 0; j < i && stack != null && InterItemStack.getStackSize(stack) > 0; ++j) {
                stack = ItemInsertionUtil.insertStack(inv, stack, j, face);
            }
        }
        if (stack != null && InterItemStack.getStackSize(stack) == 0) {
            stack = null;
        }
        return stack;
    }

    public static ItemStack insertStack(IInventory inv, ItemStack stack, int slot, EnumFacing face) {
        ItemStack itemstack = inv.func_70301_a(slot);
        if (ItemInsertionUtil.canInsertItemInSlot(inv, stack, slot, face)) {
            int tileentityhopper;
            boolean flag = false;
            if (itemstack == null) {
                int tileentityhopper2 = Math.min(stack.func_77976_d(), inv.func_70297_j_());
                if (tileentityhopper2 >= InterItemStack.getStackSize(stack)) {
                    inv.func_70299_a(slot, stack);
                    stack = null;
                } else {
                    inv.func_70299_a(slot, stack.func_77979_a(tileentityhopper2));
                }
                flag = true;
            } else if (ItemInsertionUtil.canCombine(itemstack, stack) && (tileentityhopper = Math.min(stack.func_77976_d(), inv.func_70297_j_())) > InterItemStack.getStackSize(itemstack)) {
                int i = tileentityhopper - InterItemStack.getStackSize(itemstack);
                int j = Math.min(InterItemStack.getStackSize(stack), i);
                InterItemStack.setStackSize(stack, InterItemStack.getStackSize(stack) - j);
                InterItemStack.setStackSize(itemstack, InterItemStack.getStackSize(itemstack) + j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                if (inv instanceof TileEntityHopper) {
                    TileEntityHopper tileentityhopper1 = (TileEntityHopper)inv;
                    if (tileentityhopper1.func_174914_o()) {
                        tileentityhopper1.func_145896_c(8);
                    }
                    inv.func_70296_d();
                }
                inv.func_70296_d();
            }
        }
        return stack;
    }

    public static boolean canCombine(ItemStack stack, ItemStack with) {
        return stack.func_77973_b() != with.func_77973_b() ? false : (stack.func_77960_j() != with.func_77960_j() ? false : (InterItemStack.getStackSize(stack) > stack.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)stack, (ItemStack)with)));
    }

    public static boolean canInsertItemInSlot(IInventory inv, ItemStack side, int slot, EnumFacing face) {
        return !inv.func_94041_b(slot, side) ? false : !(inv instanceof ISidedInventory) || ((ISidedInventory)inv).func_180462_a(slot, side, face);
    }
}

