/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.event;

import com.mrdimka.hammercore.annotations.MCFBus;
import com.mrdimka.hammercore.common.IWrenchItem;
import com.mrdimka.hammercore.common.utils.WorldUtil;
import com.mrdimka.hammercore.event.WrenchEvent;
import com.mrdimka.hammercore.net.HCNetwork;
import com.mrdimka.hammercore.tile.ITileDroppable;
import com.mrdimka.hammercore.tile.TileSyncable;
import com.pengu.hammercore.common.IWrenchable;
import com.pengu.hammercore.utils.WorldLocation;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@MCFBus
public class TileHandler {
    private long lastCheck;

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent evt) {
        TileEntity te;
        IBlockState state = evt.getState();
        if (state.func_177230_c() instanceof ITileDroppable) {
            ((ITileDroppable)state.func_177230_c()).createDrop(evt.getPlayer(), evt.getWorld(), evt.getPos());
        }
        if ((te = evt.getWorld().func_175625_s(evt.getPos())) instanceof ITileDroppable) {
            ((ITileDroppable)te).createDrop(evt.getPlayer(), evt.getWorld(), evt.getPos());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void playerInteract(PlayerInteractEvent.RightClickBlock evt) {
        IWrenchItem item;
        EntityPlayer player = evt.getEntityPlayer();
        if (player != null && !player.func_184586_b(evt.getHand()).func_190926_b() && (item = WorldUtil.cast(player.func_184586_b(evt.getHand()).func_77973_b(), IWrenchItem.class)) != null && item.canWrench(player.func_184586_b(evt.getHand()))) {
            MinecraftForge.EVENT_BUS.post((Event)new WrenchEvent(player, evt.getPos(), evt.getHand(), evt.getFace()));
            item.onWrenchUsed(player, evt.getPos(), evt.getHand());
            WorldLocation wl = new WorldLocation(evt.getWorld(), evt.getPos());
            if (wl.getBlock() instanceof IWrenchable && ((IWrenchable)wl.getBlock()).onWrenchUsed(wl, player, evt.getHand())) {
                HCNetwork.swingArm(player, evt.getHand());
                evt.setCanceled(true);
            } else if (wl.getTile() instanceof IWrenchable && ((IWrenchable)wl.getTile()).onWrenchUsed(wl, player, evt.getHand())) {
                HCNetwork.swingArm(player, evt.getHand());
                evt.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void place(BlockEvent.PlaceEvent evt) {
        Block block;
        TileEntity te = evt.getWorld().func_175625_s(evt.getPos());
        if (te == null && (block = evt.getPlacedBlock().func_177230_c()) instanceof ITileEntityProvider) {
            te = block.createTileEntity(evt.getWorld(), evt.getPlacedBlock());
            evt.getWorld().func_175690_a(evt.getPos(), te);
        }
        if (te instanceof TileSyncable) {
            TileSyncable tile = (TileSyncable)te;
            tile.onPlacedBy(evt.getPlayer(), evt.getHand());
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent evt) {
        long currentCheck = System.currentTimeMillis() / 50L;
        if (currentCheck - this.lastCheck > 40L) {
            this.lastCheck = currentCheck;
        }
    }
}

