/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.gui;

import com.mrdimka.hammercore.client.utils.RenderUtil;
import com.mrdimka.hammercore.common.blocks.tesseract.TileTesseract;
import com.mrdimka.hammercore.common.blocks.tesseract.TransferMode;
import com.mrdimka.hammercore.gui.GuiCentered;
import com.mrdimka.hammercore.net.HCNetwork;
import com.mrdimka.hammercore.net.pkt.PacketSetProperty;
import com.mrdimka.hammercore.net.pkt.PacketSyncSyncableTile;
import com.pengu.hammercore.color.Color;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;

public class GuiTesseract
extends GuiCentered {
    public final ResourceLocation gui = new ResourceLocation("hammercore", "textures/gui/tesseract.png");
    public final TileTesseract tile;
    public String lastTileFreq;
    public GuiTextField freq;

    public GuiTesseract(TileTesseract tile) {
        this.tile = tile;
        this.xSize = 176.0;
        this.ySize = 76.0;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        String text = this.getTileText();
        if (this.freq != null) {
            text = this.freq.func_146179_b();
        }
        this.freq = new GuiTextField(0, this.field_146289_q, (int)this.guiLeft + 23, (int)this.guiTop + 7, 130, 14);
        this.freq.func_146203_f(36);
        this.freq.func_146180_a(text);
    }

    private String getTileText() {
        String s = this.tile.frequency.get();
        if (s == null) {
            return "";
        }
        return s;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        int i;
        int guiLeft = (int)this.guiLeft;
        int guiTop = (int)this.guiTop;
        mouseX -= guiLeft;
        mouseY -= guiTop;
        if (this.lastTileFreq == null) {
            this.lastTileFreq = this.getTileText();
        }
        if (!this.lastTileFreq.equals(this.getTileText())) {
            this.lastTileFreq = this.tile.frequency.get();
            this.freq.func_146180_a(this.lastTileFreq);
        }
        this.field_146297_k.func_110434_K().func_110577_a(this.gui);
        RenderUtil.drawTexturedModalRect(guiLeft, guiTop, 0.0, 0.0, this.xSize, this.ySize);
        boolean pblic = this.tile.isPrivate.get() == false;
        boolean hover = mouseX >= 78 && mouseY >= 44 && mouseX < 98 && mouseY < 64;
        RenderUtil.drawTexturedModalRect(guiLeft + 78, guiTop + 44, 206 + (pblic ? 20 : 0), 72 + (hover ? 20 : 0), 20.0, 20.0);
        hover = mouseX >= 23 && mouseY >= 24 && mouseX < 43 && mouseY < 44;
        RenderUtil.drawTexturedModalRect(guiLeft + 23, guiTop + 24, 206.0, 32 + (hover ? 20 : 0), 20.0, 20.0);
        hover = mouseX >= 133 && mouseY >= 24 && mouseX < 153 && mouseY < 44;
        RenderUtil.drawTexturedModalRect(guiLeft + 133, guiTop + 24, 226.0, 32 + (hover ? 20 : 0), 20.0, 20.0);
        int page = this.tile.ioPage.get() == null ? 0 : (Integer)this.tile.ioPage.get();
        int startI = page * 5;
        int endI = Math.min(startI + 5, TileTesseract.getAllowedCapabilities().size());
        for (i = startI; i < endI % 5; ++i) {
            this.field_146297_k.func_110434_K().func_110577_a(this.gui);
            boolean active = this.tile.getMode(TileTesseract.getAllowedCapabilities().get(i)).active();
            int j = i - startI;
            Color.glColourRGB(active ? 0xBBFFBB : 0xFFBBBB);
            int x = 10 + j * 30;
            hover = mouseX >= x && mouseY >= -19 && mouseX < x + 30 && mouseY < 1;
            RenderUtil.drawTexturedModalRect(guiLeft + x, guiTop - 19, 176.0, hover ? 23.0 : 0.0, 30.0, 22.0);
            Color.glColourRGB(0xFFFFFF);
            this.field_146296_j.func_180450_b(TileTesseract.getCapIcon(TileTesseract.getAllowedCapabilities().get(i)), guiLeft + x + 7, guiTop - 15);
        }
        this.freq.func_146194_f();
        for (i = startI; i < endI % 5; ++i) {
            int j = i - startI;
            int x = 10 + j * 30;
            boolean bl = hover = mouseX >= x && mouseY >= -19 && mouseX < x + 30 && mouseY < 1;
            if (!hover) continue;
            this.func_146283_a(Arrays.asList(TileTesseract.getCapName(TileTesseract.getAllowedCapabilities().get(i)), this.tile.getMode(TileTesseract.getAllowedCapabilities().get(i)).active() ? TextFormatting.GREEN + "Active" : TextFormatting.RED + "Inactive"), mouseX + guiLeft, mouseY + guiTop);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.freq.func_146201_a(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int guiLeft = (int)this.guiLeft;
        int guiTop = (int)this.guiTop;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.freq.func_146192_a(mouseX, mouseY, mouseButton);
        if ((mouseX -= guiLeft) >= 78 && (mouseY -= guiTop) >= 44 && mouseX < 98 && mouseY < 64) {
            boolean prev = this.tile.isPrivate.get();
            this.tile.isPrivate.set(this.tile.isPrivate.get() == false);
            PacketSetProperty.toServer(this.tile, this.tile.isPrivate);
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)(prev ? 0.6f : 1.0f)));
        }
        if (mouseX >= 23 && mouseY >= 24 && mouseX < 43 && mouseY < 44) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.1f));
            this.tile.frequency.set(this.freq.func_146179_b());
            PacketSetProperty.toServer(this.tile, this.tile.frequency);
        }
        if (mouseX >= 133 && mouseY >= 24 && mouseX < 153 && mouseY < 44) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.9f));
            this.tile.frequency.set("");
            PacketSetProperty.toServer(this.tile, this.tile.frequency);
            this.lastTileFreq = this.getTileText();
            this.freq.func_146180_a(this.lastTileFreq);
        }
        int page = this.tile.ioPage.get() == null ? 0 : (Integer)this.tile.ioPage.get();
        int startI = page * 5;
        int endI = Math.min(startI + 5, TileTesseract.getAllowedCapabilities().size());
        for (int i = startI; i < endI % 5; ++i) {
            boolean a;
            int j = i - startI;
            int x = 10 + j * 30;
            if (mouseX < x || mouseY < -19 || mouseX >= x + 30 || mouseY >= 1) continue;
            this.tile.setMode(TileTesseract.getAllowedCapabilities().get(i), (a = this.tile.getMode(TileTesseract.getAllowedCapabilities().get(i)).active()) ? TransferMode.DECLINE : TransferMode.ALLOW);
            HCNetwork.manager.sendToServer(new PacketSyncSyncableTile(this.tile));
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)(a ? 0.9f : 1.1f)));
        }
    }
}

