/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.gui.book;

import com.mrdimka.hammercore.bookAPI.BookCategory;
import com.mrdimka.hammercore.bookAPI.BookEntry;
import com.mrdimka.hammercore.client.GLRenderState;
import com.mrdimka.hammercore.client.utils.RenderUtil;
import com.mrdimka.hammercore.gui.GuiCentered;
import com.mrdimka.hammercore.gui.book.GuiBook;
import com.mrdimka.hammercore.gui.book.GuiBookEntry;
import com.pengu.hammercore.color.Color;
import java.io.IOException;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import org.lwjgl.opengl.GL11;

public class GuiBookCategory
extends GuiCentered {
    public final BookCategory category;
    public final GuiBook bookGui;

    public GuiBookCategory(GuiBook bookGui, BookCategory cat) {
        this.category = cat;
        this.bookGui = bookGui;
        this.xSize = cat.book.width;
        this.ySize = cat.book.height;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GLRenderState.BLEND.on();
        this.field_146297_k.func_110434_K().func_110577_a(this.category.book.customBackground);
        RenderUtil.drawTexturedModalRect(this.guiLeft, this.guiTop, 0.0, 0.0, this.xSize, this.ySize);
        int FONT_HEIGHT = this.field_146289_q.field_78288_b;
        int y = 0;
        for (BookEntry ent : this.category.entries) {
            if (ent.isHidden()) continue;
            this.field_146289_q.func_175065_a(ent.getTitle(), (float)((int)this.guiLeft + 12 + (!ent.getIcon().func_190926_b() ? FONT_HEIGHT : 0)), (float)((int)this.guiTop + 14 + y), 0, false);
            if (!ent.getIcon().func_190926_b()) {
                GL11.glPushMatrix();
                GlStateManager.func_179140_f();
                RenderHelper.func_74520_c();
                GL11.glTranslated((double)(this.guiLeft + 11.0), (double)(this.guiTop + 13.0 + (double)y), (double)0.0);
                GL11.glScaled((double)(0.0625 * (double)FONT_HEIGHT), (double)(0.0625 * (double)FONT_HEIGHT), (double)1.0);
                this.field_146296_j.func_180450_b(ent.getIcon(), 0, 0);
                GlStateManager.func_179140_f();
                GL11.glPopMatrix();
            }
            y += this.field_146289_q.field_78288_b + 4;
        }
        y = 0;
        for (BookEntry ent : this.category.entries) {
            if (ent.isHidden()) continue;
            if ((double)mouseX >= this.guiLeft + 10.0 && (double)mouseY >= this.guiTop + 12.0 + (double)y && (double)mouseX < this.guiLeft + 124.0 && (double)mouseY < this.guiTop + 14.0 + (double)y + (double)this.field_146289_q.field_78288_b) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Color.glColourRGB(ent.getHoverColor());
                this.field_146297_k.func_110434_K().func_110577_a(this.category.book.customBackground);
                RenderUtil.drawTexturedModalRect(this.guiLeft + 10.0, this.guiTop + 12.0 + (double)y, 146.0, 0.0, 110.0, 11.0);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            y += this.field_146289_q.field_78288_b + 4;
        }
        GLRenderState.BLEND.off();
        boolean hoveredOver = (double)mouseX >= this.guiLeft + this.xSize / 2.0 - 9.0 && (double)mouseY >= this.guiTop + this.ySize - 4.0 && (double)mouseX < this.guiLeft + this.xSize / 2.0 + 9.0 && (double)mouseY < this.guiTop + this.ySize + 5.0;
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        this.field_146297_k.func_110434_K().func_110577_a(this.category.book.customBackground);
        RenderUtil.drawTexturedModalRect(this.guiLeft + this.xSize / 2.0 - 9.0, this.guiTop + this.ySize - 4.0, hoveredOver ? 19.0 : 0.0, 203.0, 18.0, 9.0);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 1 || mouseButton == 0 && (double)mouseX >= this.guiLeft + this.xSize / 2.0 - 9.0 && (double)mouseY >= this.guiTop + this.ySize - 4.0 && (double)mouseX < this.guiLeft + this.xSize / 2.0 + 9.0 && (double)mouseY < this.guiTop + this.ySize + 5.0) {
            this.field_146297_k.func_147108_a((GuiScreen)this.bookGui);
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int y = 0;
        if (mouseButton == 0) {
            for (BookEntry ent : this.category.entries) {
                if (ent.isHidden()) continue;
                if ((double)mouseX >= this.guiLeft + 10.0 && (double)mouseY >= this.guiTop + 12.0 + (double)y && (double)mouseX < this.guiLeft + 124.0 && (double)mouseY < this.guiTop + 14.0 + (double)y + (double)this.field_146289_q.field_78288_b) {
                    if (ent.isDisabled()) {
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.6f));
                        break;
                    }
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiBookEntry(this, ent));
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    break;
                }
                y += this.field_146289_q.field_78288_b + 4;
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)this.bookGui);
        }
    }
}

