/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.gui.book;

import com.mrdimka.hammercore.bookAPI.BookEntry;
import com.mrdimka.hammercore.bookAPI.BookPage;
import com.mrdimka.hammercore.client.GLRenderState;
import com.mrdimka.hammercore.client.utils.RenderUtil;
import com.mrdimka.hammercore.gui.GuiCentered;
import com.mrdimka.hammercore.gui.book.GuiBookCategory;
import java.io.IOException;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import org.lwjgl.opengl.GL11;

public class GuiBookEntry
extends GuiCentered {
    public final BookEntry entry;
    public final GuiBookCategory bookGui;
    public int page = 0;
    public int lastPage = -1;

    public GuiBookEntry(GuiBookCategory bookGui, BookEntry entry) {
        this.entry = entry;
        this.bookGui = bookGui;
        this.xSize = 256.0;
        this.ySize = 206.0;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        if (this.page != this.lastPage) {
            this.lastPage = this.page;
            this.entry.getPageAt(this.page).prepare();
        }
        GLRenderState.BLEND.on();
        this.field_146297_k.func_110434_K().func_110577_a(this.entry.category.book.customEntryBackground);
        RenderUtil.drawTexturedModalRect(this.guiLeft, this.guiTop, 0.0, 0.0, this.xSize, this.ySize);
        if (this.entry.getPageCount() > 0) {
            BookPage page = this.entry.getPageAt(this.page);
            GL11.glPushMatrix();
            GL11.glTranslated((double)this.guiLeft, (double)this.guiTop, (double)0.0);
            page.render(mouseX, mouseY);
            GL11.glPopMatrix();
        } else {
            this.field_146297_k.func_147108_a((GuiScreen)this.bookGui);
        }
        GLRenderState.BLEND.off();
        boolean hoveredOver = (double)mouseX >= this.guiLeft + this.xSize / 2.0 - 9.0 && (double)mouseY >= this.guiTop + this.ySize - 4.0 && (double)mouseX < this.guiLeft + this.xSize / 2.0 + 9.0 && (double)mouseY < this.guiTop + this.ySize + 5.0;
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        this.field_146297_k.func_110434_K().func_110577_a(this.entry.category.book.customBackground);
        RenderUtil.drawTexturedModalRect(this.guiLeft + this.xSize / 2.0 - 9.0, this.guiTop + this.ySize - 4.0, hoveredOver ? 19.0 : 0.0, 203.0, 18.0, 9.0);
        if (this.page < this.entry.getPageCount() - 1) {
            hoveredOver = (double)mouseX >= this.guiLeft + this.xSize - 18.0 && (double)mouseY >= this.guiTop + this.ySize - 6.0 && (double)mouseX < this.guiLeft + this.xSize && (double)mouseY < this.guiTop + this.ySize + 4.0;
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            this.field_146297_k.func_110434_K().func_110577_a(this.entry.category.book.customBackground);
            RenderUtil.drawTexturedModalRect(this.guiLeft + this.xSize - 18.0, this.guiTop + this.ySize - 6.0, hoveredOver ? 19.0 : 0.0, 181.0, 18.0, 10.0);
        }
        if (this.page > 0) {
            hoveredOver = (double)mouseX >= this.guiLeft && (double)mouseY >= this.guiTop + this.ySize - 6.0 && (double)mouseX < this.guiLeft + 18.0 && (double)mouseY < this.guiTop + this.ySize + 4.0;
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            this.field_146297_k.func_110434_K().func_110577_a(this.entry.category.book.customBackground);
            RenderUtil.drawTexturedModalRect(this.guiLeft, this.guiTop + this.ySize - 6.0, hoveredOver ? 19.0 : 0.0, 192.0, 18.0, 10.0);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 1 || mouseButton == 0 && (double)mouseX >= this.guiLeft + this.xSize / 2.0 - 9.0 && (double)mouseY >= this.guiTop + this.ySize - 4.0 && (double)mouseX < this.guiLeft + this.xSize / 2.0 + 9.0 && (double)mouseY < this.guiTop + this.ySize + 5.0) {
            this.field_146297_k.func_147108_a((GuiScreen)this.bookGui);
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return;
        }
        if (mouseButton == 0 && this.page < this.entry.getPageCount() - 1 && (double)mouseX >= this.guiLeft + this.xSize - 18.0 && (double)mouseY >= this.guiTop + this.ySize - 6.0 && (double)mouseX < this.guiLeft + this.xSize && (double)mouseY < this.guiTop + this.ySize + 4.0) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            ++this.page;
        }
        if (mouseButton == 0 && this.page > 0 && (double)mouseX >= this.guiLeft && (double)mouseY >= this.guiTop + this.ySize - 6.0 && (double)mouseX < this.guiLeft + 18.0 && (double)mouseY < this.guiTop + this.ySize + 4.0) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            --this.page;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)this.bookGui);
        }
    }
}

