/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.init;

import com.mrdimka.hammercore.api.INoItemBlock;
import com.mrdimka.hammercore.api.ITileBlock;
import com.mrdimka.hammercore.api.multipart.BlockMultipartProvider;
import com.mrdimka.hammercore.common.items.MultiVariantItem;
import com.mrdimka.hammercore.init.ModItems;
import com.pengu.hammercore.common.blocks.IItemBlock;
import com.pengu.hammercore.utils.IRegisterListener;
import com.pengu.hammercore.utils.SoundObject;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class SimpleRegistration {
    public static void registerFieldItemsFrom(Class<?> owner, String modid, CreativeTabs tab) {
        Field[] fs;
        for (Field f : fs = owner.getDeclaredFields()) {
            if (!Item.class.isAssignableFrom(f.getType())) continue;
            try {
                f.setAccessible(true);
                SimpleRegistration.registerItem((Item)f.get(null), modid, tab);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void registerFieldBlocksFrom(Class<?> owner, String modid, CreativeTabs tab) {
        Field[] fs;
        for (Field f : fs = owner.getDeclaredFields()) {
            if (!Block.class.isAssignableFrom(f.getType())) continue;
            try {
                f.setAccessible(true);
                SimpleRegistration.registerBlock((Block)f.get(null), modid, tab);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void registerFieldSoundsFrom(Class<?> owner) {
        Field[] fs;
        for (Field f : fs = owner.getDeclaredFields()) {
            if (!SoundObject.class.isAssignableFrom(f.getType())) continue;
            try {
                f.setAccessible(true);
                SimpleRegistration.registerSound((SoundObject)f.get(null));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void registerSound(SoundObject sound) {
        sound.sound = (SoundEvent)new SoundEvent(sound.name).setRegistryName(sound.name);
        sound.sound = (SoundEvent)GameRegistry.register((IForgeRegistryEntry)sound.sound);
    }

    public static void registerItem(Item item, String modid, CreativeTabs tab) {
        if (item == null) {
            return;
        }
        String name = item.func_77658_a().substring("item.".length());
        item.setRegistryName(modid, name);
        item.func_77655_b(modid + ":" + name);
        if (tab != null) {
            item.func_77637_a(tab);
        }
        GameRegistry.register((IForgeRegistryEntry)item);
        if (item instanceof IRegisterListener) {
            ((IRegisterListener)item).onRegistered();
        }
        if (item instanceof MultiVariantItem) {
            ModItems.multiitems.add((MultiVariantItem)item);
        } else {
            ModItems.items.add(item);
        }
    }

    public static void registerBlock(Block block, String modid, CreativeTabs tab) {
        ITileEntityProvider te;
        TileEntity t;
        if (block == null) {
            return;
        }
        String name = block.func_149739_a().substring("tile.".length());
        block.func_149663_c(modid + ":" + name);
        block.func_149647_a(tab);
        Object ib = null;
        ib = block instanceof BlockMultipartProvider ? ((BlockMultipartProvider)block).createItem() : (block instanceof IItemBlock ? ((IItemBlock)block).getItemBlock() : new ItemBlock(block));
        GameRegistry.register((IForgeRegistryEntry)block, (ResourceLocation)new ResourceLocation(modid, name));
        if (!(block instanceof INoItemBlock)) {
            GameRegistry.register((IForgeRegistryEntry)ib.setRegistryName(block.getRegistryName()));
        }
        if (block instanceof IRegisterListener) {
            ((IRegisterListener)block).onRegistered();
        }
        if (block instanceof ITileBlock) {
            Class c = ((ITileBlock)block).getTileClass();
            GameRegistry.registerTileEntity(c, (String)(modid + ":" + c.getName().substring(c.getName().lastIndexOf(".") + 1).toLowerCase()));
        } else if (block instanceof ITileEntityProvider && (t = (te = (ITileEntityProvider)block).func_149915_a(null, 0)) != null) {
            Class<?> c = t.getClass();
            GameRegistry.registerTileEntity(c, (String)(modid + ":" + c.getName().substring(c.getName().lastIndexOf(".") + 1).toLowerCase()));
        }
        if (!(block instanceof INoItemBlock)) {
            Item i = Item.func_150898_a((Block)block);
            if (i instanceof IRegisterListener) {
                ((IRegisterListener)i).onRegistered();
            }
            if (i instanceof MultiVariantItem) {
                ModItems.multiitems.add((MultiVariantItem)i);
            } else if (i != null) {
                ModItems.items.add(i);
            }
        }
    }
}

