/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.math;

import com.mrdimka.hammercore.math.functions.ExpressionFunction;
import com.mrdimka.hammercore.math.functions.FunctionMath;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class BigExpressionEvaluator {
    private final String str;
    private int pos = -1;
    private int ch;
    private final List<ExpressionFunction> functions = new ArrayList<ExpressionFunction>();

    public BigExpressionEvaluator(String str) {
        this.addFunction(FunctionMath.inst);
        str = str.replaceAll("\u1d28", "PI");
        str = str.replaceAll("PI", "3.141592653589793");
        this.str = str = str.replaceAll("E", "2.718281828459045");
    }

    private void nextChar() {
        this.ch = ++this.pos < this.str.length() ? (int)this.str.charAt(this.pos) : -1;
    }

    private boolean eat(int charToEat) {
        while (this.ch == 32) {
            this.nextChar();
        }
        if (this.ch == charToEat) {
            this.nextChar();
            return true;
        }
        return false;
    }

    public final BigDecimal parse() {
        this.pos = -1;
        this.nextChar();
        BigDecimal x = this.parseExpression();
        if (this.pos < this.str.length()) {
            throw new RuntimeException("Unexpected: " + (char)this.ch);
        }
        return x;
    }

    private BigDecimal parseExpression() {
        BigDecimal x = this.parseTerm();
        while (true) {
            if (this.eat(43)) {
                x = x.add(this.parseTerm());
                continue;
            }
            if (!this.eat(45)) break;
            x = x.subtract(this.parseTerm());
        }
        return x;
    }

    private BigDecimal parseTerm() {
        BigDecimal x = this.parseFactor();
        while (true) {
            if (this.eat(42)) {
                x = x.multiply(this.parseFactor());
                continue;
            }
            if (this.eat(47) || this.eat(58)) {
                x = x.divide(this.parseFactor());
                continue;
            }
            if (this.eat(37)) {
                x = x.remainder(this.parseFactor());
                continue;
            }
            if (!this.eat(94)) break;
            x = x.pow(this.parseFactor().intValue());
        }
        return x;
    }

    private BigDecimal parseFactor() {
        BigDecimal x;
        if (this.eat(43)) {
            return this.parseFactor();
        }
        if (this.eat(45)) {
            return this.parseFactor().negate();
        }
        int startPos = this.pos;
        if (this.eat(40)) {
            x = this.parseExpression();
            this.eat(41);
        } else if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
            while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                this.nextChar();
            }
            x = new BigDecimal(this.str.substring(startPos, this.pos));
        } else if (this.ch >= 97 && this.ch <= 122) {
            while (this.ch >= 97 && this.ch <= 122) {
                this.nextChar();
            }
            String func = this.str.substring(startPos, this.pos).toLowerCase();
            x = this.parseFactor();
            boolean funcFound = false;
            for (ExpressionFunction f : this.functions) {
                if (!f.accepts(func, x)) continue;
                x = f.apply(func, x);
                funcFound = true;
                break;
            }
            if (!funcFound) {
                throw new RuntimeException("Unknown function: " + func);
            }
        } else {
            throw new RuntimeException("Unexpected: " + (char)this.ch);
        }
        return x;
    }

    public void addFunction(ExpressionFunction func) {
        if (this.functions.contains(func)) {
            return;
        }
        this.functions.add(func);
    }

    public static String evaluate(String expression, ExpressionFunction ... functions) {
        BigDecimal result = BigExpressionEvaluator.evaluateDouble(expression, functions);
        if (result.toString().equals(result.toBigInteger().toString())) {
            return result.toBigInteger() + "";
        }
        return result + "";
    }

    public static BigDecimal evaluateDouble(String expression, ExpressionFunction ... functions) {
        try {
            return new BigDecimal(expression);
        }
        catch (Throwable throwable) {
            BigExpressionEvaluator eval = new BigExpressionEvaluator(expression);
            for (ExpressionFunction func : functions) {
                eval.addFunction(func);
            }
            return eval.parse();
        }
    }
}

