/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.math.functions;

import com.mrdimka.hammercore.math.functions.ExpressionFunction;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Set;

public class FunctionMath
extends ExpressionFunction {
    private static final SecureRandom rand = new SecureRandom((System.currentTimeMillis() + System.nanoTime() + "").getBytes());
    public static final FunctionMath inst = new FunctionMath();
    private final Set<String> allowedFuncs = new HashSet<String>();
    private static final double LOG10 = Math.log(10.0);
    private static final double LOG2 = Math.log(2.0);
    public static MathContext context = new MathContext(100);

    public FunctionMath() {
        super("Math");
        for (Method m : Math.class.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers()) || m.getParameterTypes().length != 1 || m.getParameterTypes()[0] != Double.TYPE && m.getParameterTypes()[0] != Double.class) continue;
            this.allowedFuncs.add(m.getName());
        }
        for (String s : this.allowedFuncs) {
            System.out.println(s);
        }
    }

    @Override
    public boolean accepts(String functionName, double x) {
        return this.allowedFuncs.contains(functionName = functionName.toLowerCase()) || functionName.equals("rand");
    }

    @Override
    public boolean accepts(String functionName, BigDecimal x) {
        return this.allowedFuncs.contains(functionName = functionName.toLowerCase()) || functionName.equals("rand");
    }

    @Override
    public double apply(String functionName, double x) {
        if ((functionName = functionName.toLowerCase()).equals("rand")) {
            return (double)rand.nextInt(Integer.MAX_VALUE) / 2.147483647E9 * x;
        }
        try {
            return (Double)Math.class.getMethod(functionName, Double.TYPE).invoke(null, x);
        }
        catch (Throwable throwable) {
            return x;
        }
    }

    @Override
    public BigDecimal apply(String functionName, BigDecimal x) {
        if ((functionName = functionName.toLowerCase()).equals("rand")) {
            return x.multiply(new BigDecimal((double)rand.nextInt(Integer.MAX_VALUE) / 2.147483647E9));
        }
        if (functionName.equals("log")) {
            BigInteger val = x.unscaledValue();
            int blex = val.bitLength() - 1022;
            if (blex > 0) {
                val = val.shiftRight(blex);
            }
            double res = Math.log(val.doubleValue());
            return new BigDecimal((blex > 0 ? res + (double)blex * LOG2 : res) + (double)x.scale() * LOG10);
        }
        return x;
    }
}

