/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.modbrowser;

import com.mrdimka.hammercore.client.UV;
import com.mrdimka.hammercore.client.utils.GLImageManager;
import com.mrdimka.hammercore.common.utils.DynamicObject;
import com.mrdimka.hammercore.common.utils.IOUtils;
import com.mrdimka.hammercore.common.utils.MD5;
import com.mrdimka.hammercore.json.JSONArray;
import com.mrdimka.hammercore.json.JSONException;
import com.mrdimka.hammercore.json.JSONObject;
import com.mrdimka.hammercore.json.JSONTokener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.lwjgl.opengl.GL11;

public class ModBrowser {
    public static final String URL_BASE = "https://raw.githubusercontent.com/APengu/HammerCore/mod-list/";
    public static final String SHEETS = "https://raw.githubusercontent.com/APengu/HammerCore/mod-list/sheets/";
    private static final Map<String, Integer> glImages = new HashMap<String, Integer>();
    private Map<String, Version> versions = new HashMap<String, Version>();
    public final List<Mod> mods = new ArrayList<Mod>();
    public final Map<String, LoadedMod> loadedMods = new HashMap<String, LoadedMod>();

    public ModBrowser(DynamicObject<String> status) throws IOException {
        Iterator<Mod> object;
        status.set("Checking mod list...");
        for (LoadedMod mod : ModBrowser.collectMods(status)) {
            this.loadedMods.put(mod.modid, mod);
        }
        status.set("Connecting to github...");
        InputStream input = new URL("https://raw.githubusercontent.com/APengu/HammerCore/mod-list/version.types").openConnection().getInputStream();
        status.set("Downloading version list...");
        String jsonstr = new String(IOUtils.pipeOut(input), "UTF-8");
        status.set("Parsing version list...");
        try {
            object = (JSONObject)new JSONTokener(jsonstr).nextValue();
            for (String key : ((JSONObject)((Object)object)).keySet()) {
                JSONObject version = ((JSONObject)((Object)object)).getJSONObject(key);
                JSONArray uv = version.getJSONArray("icon");
                JSONObject translations = version.getJSONObject("translations");
                Version ver = new Version();
                ver.id = key;
                ver.iconId = version.getString("sheet");
                ver.iconPos = new Vec3i(uv.getInt(0), uv.getInt(1), 0);
                for (String lang : translations.keySet()) {
                    String val = translations.getString(lang);
                    ver.translations.put(lang.toLowerCase(), val);
                    status.set(lang + "=" + val);
                }
                this.versions.put(key, ver);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        status.set("Downloading mod list for 1.11.2...");
        jsonstr = new String(IOUtils.downloadData("https://raw.githubusercontent.com/APengu/HammerCore/mod-list/mods-1.11.2.prop"));
        status.set("Parsing mod list...");
        try {
            object = (JSONObject)new JSONTokener(jsonstr).nextValue();
            for (String modname : ((JSONObject)((Object)object)).keySet()) {
                JSONObject modjson = ((JSONObject)((Object)object)).getJSONObject(modname);
                Mod mod = new Mod();
                mod.modName = modname;
                mod.modid = modjson.getString("modid");
                mod.iconUrl = modjson.getString("logo");
                mod.description = modjson.getString("tooltip");
                mod.authors = Arrays.toString(modjson.getJSONArray("authors").values());
                mod.authors = mod.authors.substring(1, mod.authors.length() - 1);
                JSONObject versions = modjson.getJSONObject("versions");
                for (String vertype : versions.keySet()) {
                    JSONObject version = versions.getJSONObject(vertype);
                    Version ver = this.versions.get(vertype);
                    mod.supportedVersions.put(ver, version.getString("version"));
                    mod.fileVersions.put(version.getString("version"), version.getString("download"));
                    mod.fileSizes.put(version.getString("version"), version.getLong("size"));
                }
                this.mods.add(mod);
            }
        }
        catch (Throwable object2) {
            // empty catch block
        }
        status.set("Loading icons...");
        for (String key : this.versions.keySet()) {
            Version ver = this.versions.get(key);
            status.set("Loading icon for version " + ver.id + "...");
            ver.loadIcon();
        }
        for (Mod mod : this.mods) {
            status.set("Loading icon for mod " + mod.modName + "...");
            mod.loadIcon();
        }
        for (int i = 0; i < 8; ++i) {
            try {
                Mod[] sorted = null;
                sorted = this.mods.toArray(new Mod[0]);
                Arrays.sort(sorted, new Comparator<Mod>(){

                    @Override
                    public int compare(Mod o1, Mod o2) {
                        return o1.modName.compareTo(o2.modName);
                    }
                });
                this.mods.clear();
                this.mods.addAll(Arrays.asList(sorted));
                break;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        status.set("Done!");
    }

    public static List<LoadedMod> collectMods(DynamicObject<String> status) {
        ArrayList<LoadedMod> mods = new ArrayList<LoadedMod>();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            LoadedMod mod = new LoadedMod();
            mod.description = mc.getMetadata().description;
            mod.modid = mc.getModId();
            mod.modname = mc.getName();
            mod.version = mc.getVersion();
            mod.associated_file = mc.getSource();
            mods.add(mod);
        }
        return mods;
    }

    public static final class Version {
        private String id;
        private String iconId;
        private Vec3i iconPos;
        private final Map<String, String> translations = new HashMap<String, String>();
        private int openglID;
        public UV icon;

        public String getId() {
            String val = this.translations.get(Minecraft.func_71410_x().field_71474_y.field_74363_ab.toLowerCase());
            String valen = this.translations.get("en_us");
            return val != null ? val : (valen != null ? valen : this.id);
        }

        private void loadIcon() throws IOException {
            byte[] data = IOUtils.downloadData(ModBrowser.SHEETS + this.iconId);
            String md5 = MD5.encrypt(data);
            BufferedImage img = ImageIO.read(new ByteArrayInputStream(data));
            Minecraft.func_71410_x().func_152344_a(() -> {
                int newGLID = glImages.get(md5) != null ? (Integer)glImages.get(md5) : GL11.glGenTextures();
                GLImageManager.loadTexture(img, newGLID, false);
                this.openglID = newGLID;
                glImages.put(md5, newGLID);
            });
            this.icon = new UV(TextureMap.field_174945_f, this.iconPos.func_177958_n(), this.iconPos.func_177956_o(), 25.0, 25.0){

                @Override
                public void bindTexture() {
                    GL11.glBindTexture((int)3553, (int)openglID);
                }
            };
        }
    }

    public static final class Mod {
        public final Map<Version, String> supportedVersions = new HashMap<Version, String>();
        public final Map<String, String> fileVersions = new HashMap<String, String>();
        public final Map<String, Long> fileSizes = new HashMap<String, Long>();
        public String modName;
        public String modid;
        public String description;
        public String authors;
        public UV icon;
        private String iconUrl;
        private int openglID;

        private void loadIcon() throws IOException {
            byte[] data = IOUtils.downloadData(this.iconUrl);
            String md5 = MD5.encrypt(data);
            BufferedImage img = ImageIO.read(new ByteArrayInputStream(data));
            Minecraft.func_71410_x().func_152344_a(() -> {
                int newGLID = glImages.get(md5) != null ? (Integer)glImages.get(md5) : GL11.glGenTextures();
                GLImageManager.loadTexture(img, newGLID, false);
                this.openglID = newGLID;
                glImages.put(md5, newGLID);
            });
            this.icon = new UV(TextureMap.field_174945_f, 0.0, 0.0, 256.0, 256.0){

                @Override
                public void bindTexture() {
                    GL11.glBindTexture((int)3553, (int)openglID);
                }
            };
        }
    }

    public static final class LoadedMod {
        public String version;
        public String modid;
        public String modname;
        public String description;
        public File associated_file;
    }
}

