/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.net.pkt;

import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.net.HCNetwork;
import com.mrdimka.hammercore.net.packetAPI.IPacket;
import com.mrdimka.hammercore.net.packetAPI.IPacketListener;
import com.mrdimka.hammercore.tile.TileSyncable;
import com.pengu.hammercore.net.utils.NetPropertyAbstract;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSetProperty
implements IPacket,
IPacketListener<PacketSetProperty, IPacket> {
    protected NBTTagCompound nbt;

    @SideOnly(value=Side.CLIENT)
    public static void toServer(TileSyncable tile, NetPropertyAbstract abs) {
        HCNetwork.manager.sendToServer(new PacketSetProperty(tile, abs));
    }

    public PacketSetProperty(TileSyncable tile, NetPropertyAbstract property) {
        this.nbt = new NBTTagCompound();
        this.nbt.func_74772_a("Pos", tile.func_174877_v().func_177986_g());
        this.nbt.func_74768_a("Dim", tile.func_145831_w().field_73011_w.getDimension());
        this.nbt.func_74782_a("Data", (NBTBase)property.writeToNBT(new NBTTagCompound()));
        this.nbt.func_74768_a("Id", property.getId());
    }

    public PacketSetProperty() {
    }

    @Override
    public IPacket onArrived(PacketSetProperty packet, MessageContext context) {
        if (context.side == Side.SERVER) {
            NBTTagCompound nbt = packet.nbt;
            int dim = nbt.func_74762_e("Dim");
            BlockPos pos = BlockPos.func_177969_a((long)nbt.func_74763_f("Pos"));
            NBTTagCompound prop = nbt.func_74775_l("Data");
            int id = nbt.func_74762_e("Id");
            MinecraftServer server = context.getServerHandler().field_147369_b.field_71133_b;
            WorldServer world = server.func_71218_a(dim);
            if (world != null && world.func_175667_e(pos) && world.func_175625_s(pos) instanceof TileSyncable) {
                ((TileSyncable)world.func_175625_s(pos)).load(id, prop);
            }
        } else {
            HammerCore.LOG.warn("Attempted to run PacketSetProperty on client. This is not going to work! Use TileSyncable.sync() instead!", new Object[0]);
        }
        return null;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("Data", (NBTBase)this.nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.nbt = nbt.func_74775_l("Data");
    }
}

