/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.proxy;

import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.bookAPI.Book;
import com.mrdimka.hammercore.bookAPI.BookCategory;
import com.mrdimka.hammercore.bookAPI.BookEntry;
import com.mrdimka.hammercore.bookAPI.pages.BookPageTextPlain;
import com.mrdimka.hammercore.event.RegisterBookEvent;
import com.mrdimka.hammercore.gui.book.GuiBook;
import com.mrdimka.hammercore.init.ModItems;
import com.mrdimka.hammercore.proxy.BookProxy_Common;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BookProxy_Client
extends BookProxy_Common {
    private final Map<String, Book> books = new HashMap<String, Book>();

    @Override
    public Object getBookInstanceById(String id) {
        return this.books.get(id);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBookInstance(Book book) {
        String id = book.bookId;
        if (this.books.putIfAbsent(id, book) != null) {
            HammerCore.LOG.bigWarn("A mod tried to register book with already used id: " + id + ", registered: " + this.books.get(id) + ", failed to register: " + book, new Object[0]);
        }
    }

    @Override
    public void openBookGui(String bookId) {
        if (this.getBookInstanceById(bookId) != null) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiBook((Book)this.getBookInstanceById(bookId)));
        }
    }

    @Override
    public void init() {
        this.registerManual();
        MinecraftForge.EVENT_BUS.post((Event)new RegisterBookEvent());
    }

    private void registerManual() {
        Book hammerCoreManual = new Book("hammercore:manual");
        BookCategory items = new BookCategory(hammerCoreManual, "items");
        items.setIcon(new ItemStack(ModItems.manual));
        BookCategory blocks = new BookCategory(hammerCoreManual, "blocks");
        BookEntry entry = new BookEntry(items, "calculatron", "gui.hammercore:manual/items/calculatron.title");
        entry.setIcon(new ItemStack(ModItems.calculatron));
        new BookPageTextPlain(entry, "gui.hammercore:manual/items/calculatron.desc");
        this.registerBookInstance(hammerCoreManual);
    }
}

