/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.proxy;

import java.lang.reflect.Constructor;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;

public class PipelineProxy_Common {
    public Side getGameSide() {
        return Side.SERVER;
    }

    @Nullable
    public final <T> T pipeIfOnGameSide(T t, Side passSide) {
        if (passSide == this.getGameSide()) {
            return t;
        }
        return null;
    }

    @Nullable
    public final <T> T createAndPipeIfOnGameSide(String pipedClass, Side passSide, Object ... arguments) {
        if (passSide == this.getGameSide()) {
            try {
                Class<?> c = Class.forName(pipedClass);
                Class[] args = new Class[arguments.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = arguments[i].getClass();
                }
                Constructor<?> constr = c.getConstructor(args);
                return (T)constr.newInstance(arguments);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public final <T> T createAndPipeDependingOnSide(String clientClass, String serverClass, Object ... arguments) {
        if (this.getGameSide() == Side.CLIENT) {
            return this.createAndPipeIfOnGameSide(clientClass, this.getGameSide(), arguments);
        }
        if (this.getGameSide() == Side.SERVER) {
            return this.createAndPipeIfOnGameSide(serverClass, this.getGameSide(), arguments);
        }
        return null;
    }
}

