/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.recipeAPI.registry;

import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.common.utils.JSONObjectToNBT;
import com.mrdimka.hammercore.json.JSONArray;
import com.mrdimka.hammercore.json.JSONException;
import com.mrdimka.hammercore.json.JSONTokener;
import com.mrdimka.hammercore.recipeAPI.registry.GlobalRecipeScript;
import com.mrdimka.hammercore.recipeAPI.registry.IRecipeScript;
import com.mrdimka.hammercore.recipeAPI.registry.IRecipeTypeRegistry;
import com.mrdimka.hammercore.recipeAPI.registry.SimpleRecipeScript;
import com.mrdimka.hammercore.recipeAPI.types.IRecipeType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RecipeTypeRegistry
implements IRecipeTypeRegistry {
    private final Set<IRecipeType> types = new HashSet<IRecipeType>();

    @Override
    public void register(IRecipeType type) {
        this.types.add(type);
    }

    public void forEach(Consumer<IRecipeType> cycle) {
        this.types.stream().forEach(cycle);
    }

    public IRecipeScript parseAll(String[] jsons) throws JSONException {
        ArrayList<SimpleRecipeScript> scripts = new ArrayList<SimpleRecipeScript>();
        for (String json : jsons) {
            scripts.add(this.parse(json));
        }
        return new GlobalRecipeScript(scripts.toArray(new SimpleRecipeScript[scripts.size()]));
    }

    public SimpleRecipeScript parse(String json) throws JSONException {
        return this.parse(JSONObjectToNBT.convert((JSONArray)new JSONTokener(json).nextValue()));
    }

    public SimpleRecipeScript parse(NBTTagList list) {
        SimpleRecipeScript script = new SimpleRecipeScript();
        script.makeTag = list.func_74737_b();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            String id = nbt.func_74779_i("id");
            NBTTagCompound r = nbt.func_74775_l("recipe");
            boolean[] parsed = new boolean[1];
            this.forEach(t -> {
                if (t.getTypeId().equals(id)) {
                    parsed[0] = true;
                    Object o = t.createRecipe(r);
                    script.types.put(o, (IRecipeType)t);
                    if (nbt.func_74767_n("remove")) {
                        script.swaps.add(o);
                    }
                }
            });
            if (parsed[0]) continue;
            HammerCore.LOG.warn("Warning: Found non-existing/missing recipe type: " + id + "! This will get ignored.", new Object[0]);
        }
        return script;
    }
}

