/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.recipeAPI.registry;

import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.intr.jei.IJeiRecipeModifier;
import com.mrdimka.hammercore.recipeAPI.registry.IRecipeScript;
import com.mrdimka.hammercore.recipeAPI.types.IRecipeType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SimpleRecipeScript
implements IRecipeScript {
    public final Map<Object, IRecipeType> types = new HashMap<Object, IRecipeType>();
    public final Set<Object> swaps = new HashSet<Object>();
    public NBTTagList makeTag;
    private final Set<Object> JEIRecipesAdded = new HashSet<Object>();
    private final Set<Object> JEIRecipesRemoved = new HashSet<Object>();

    @Override
    public void add() {
        for (Object o : this.types.keySet()) {
            Object recipe;
            IRecipeType type = this.types.get(o);
            if (this.swaps.contains(o) && type.swapAddRemoveSupported(o)) {
                type.removeOnLoad(o);
                if (!type.isJeiSupported(o) || IJeiRecipeModifier.Instance.JEIModifier == null) continue;
                recipe = type.getJeiRecipeFor(o, true);
                this.JEIRecipesRemoved.add(recipe);
                IJeiRecipeModifier.Instance.JEIModifier.removeJEI(recipe);
                continue;
            }
            if (this.swaps.contains(o)) {
                HammerCore.LOG.warn("Found recipe to remove but it doesn't support remove reverse operation!", new Object[0]);
            }
            type.addRecipe(o);
            if (!type.isJeiSupported(o) || IJeiRecipeModifier.Instance.JEIModifier == null) continue;
            recipe = type.getJeiRecipeFor(o, false);
            this.JEIRecipesAdded.add(recipe);
            IJeiRecipeModifier.Instance.JEIModifier.addJEI(recipe);
        }
    }

    @Override
    public void remove() {
        if (IJeiRecipeModifier.Instance.JEIModifier != null) {
            for (Object recipe : this.JEIRecipesAdded) {
                IJeiRecipeModifier.Instance.JEIModifier.removeJEI(recipe);
            }
            for (Object recipe : this.JEIRecipesRemoved) {
                IJeiRecipeModifier.Instance.JEIModifier.addJEI(recipe);
            }
        }
        for (Object o : this.types.keySet()) {
            IRecipeType type = this.types.get(o);
            if (type.swapAddRemoveSupported(o)) {
                type.addOnUnload(o);
                continue;
            }
            type.removeRecipe(o);
        }
    }

    @Override
    public NBTTagCompound writeToNbt() {
        return null;
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
    }
}

