/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.recipeAPI.types;

import com.mrdimka.hammercore.common.utils.StringToItemStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.oredict.OreDictionary;

public interface IRecipeType<T> {
    public boolean isJeiSupported(T var1);

    @Deprecated
    default public Object getJeiRecipeFor(T recipe) {
        return null;
    }

    default public Object getJeiRecipeFor(T recipe, boolean remove) {
        return this.getJeiRecipeFor(recipe);
    }

    public String getTypeId();

    public T createRecipe(NBTTagCompound var1) throws RecipeParseException;

    public void addRecipe(T var1);

    public void removeRecipe(T var1);

    default public boolean swapAddRemoveSupported(T recipe) {
        return false;
    }

    default public void removeOnLoad(T recipe) {
    }

    default public void addOnUnload(T recipe) {
    }

    default public ItemStack parseStack(String stack, String nbt) {
        return StringToItemStack.toItemStack(stack, nbt);
    }

    default public ItemStack loadStack(NBTTagCompound nbt) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("id", nbt.func_74779_i("id"));
        if (nbt.func_74764_b("count")) {
            compound.func_74774_a("Count", (byte)nbt.func_74762_e("count"));
        } else {
            compound.func_74774_a("Count", (byte)1);
        }
        if (nbt.func_74764_b("damage")) {
            if (nbt.func_74762_e("damage") < 0) {
                compound.func_74777_a("Damage", (short)Short.MAX_VALUE);
            } else {
                compound.func_74777_a("Damage", (short)nbt.func_74762_e("damage"));
            }
        }
        if (nbt.func_74764_b("tag")) {
            compound.func_74782_a("tag", (NBTBase)nbt.func_74775_l("tag"));
        }
        if (nbt.func_74764_b("ForgeCaps")) {
            compound.func_74782_a("ForgeCaps", (NBTBase)nbt.func_74775_l("ForgeCaps"));
        }
        return new ItemStack(compound);
    }

    default public List<ItemStack> loadStacks(NBTBase base, String item) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (base == null) {
            return stacks;
        }
        if (base instanceof NBTTagCompound) {
            stacks.add(this.loadStack((NBTTagCompound)base));
        } else if (base instanceof NBTTagString) {
            stacks.addAll((Collection<ItemStack>)OreDictionary.getOres((String)((NBTTagString)base).func_150285_a_()));
        } else if (base instanceof NBTTagList && ((NBTTagList)base).func_150303_d() == 10) {
            for (int i = 0; i < ((NBTTagList)base).func_74745_c(); ++i) {
                NBTTagCompound nbt = ((NBTTagList)base).func_150305_b(i);
                stacks.add(this.loadStack(nbt));
            }
        } else if (base instanceof NBTTagList && ((NBTTagList)base).func_150303_d() == 8) {
            for (int i = 0; i < ((NBTTagList)base).func_74745_c(); ++i) {
                String od = ((NBTTagList)base).func_150307_f(i);
                stacks.addAll((Collection<ItemStack>)OreDictionary.getOres((String)od));
            }
        } else {
            throw new RecipeParseException("Undefined type for ingredient '" + item + "': TagID: " + base.func_74732_a() + ", Content: " + base);
        }
        return stacks;
    }

    public static class RecipeParseException
    extends RuntimeException {
        public RecipeParseException(String msg) {
            super(msg);
        }
    }
}

