/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.recipeAPI.vanilla.crafting;

import com.mrdimka.hammercore.recipeAPI.types.IRecipeType;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ShapelessRecipeType
implements IRecipeType<ShapelessOreRecipe> {
    @Override
    public boolean isJeiSupported(ShapelessOreRecipe recipe) {
        return true;
    }

    @Override
    public Object getJeiRecipeFor(ShapelessOreRecipe recipe) {
        return recipe;
    }

    @Override
    public String getTypeId() {
        return "shapeless_recipe";
    }

    @Override
    public ShapelessOreRecipe createRecipe(NBTTagCompound json) {
        ItemStack out = this.loadStack(json.func_74775_l("output"));
        ArrayList<String> data = new ArrayList<String>();
        NBTTagList ingredients = json.func_150295_c("ingredients", 10);
        for (int i = 0; i < ingredients.func_74745_c(); ++i) {
            String item;
            NBTTagCompound ing = ingredients.func_150305_b(i);
            if (ing.func_150297_b(item = "item", 8)) {
                data.add(ing.func_74779_i(item));
                continue;
            }
            if (ing.func_150297_b(item, 10)) {
                data.add((String)this.loadStack(ing.func_74775_l(item)));
                continue;
            }
            throw new IRecipeType.RecipeParseException("Undefined type for ingredient '" + i + "': TagID: " + ing.func_150299_b(item) + ", Content: " + ing.func_74781_a(item));
        }
        return new ShapelessOreRecipe(out, data.toArray());
    }

    @Override
    public void addRecipe(ShapelessOreRecipe recipe) {
        CraftingManager.func_77594_a().func_180302_a((IRecipe)recipe);
    }

    @Override
    public void removeRecipe(ShapelessOreRecipe recipe) {
        CraftingManager.func_77594_a().func_77592_b().remove(recipe);
    }
}

